/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.keyprovider;

import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.KeyUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.keyprovider.KeyPairProvider;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import java.security.KeyPair;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;

public class MappedKeyPairProvider
implements KeyPairProvider {
    public static final Function<Map<String, KeyPair>, KeyPairProvider> MAP_TO_KEY_PAIR_PROVIDER = MappedKeyPairProvider::new;
    private final Map<String, KeyPair> pairsMap;

    public MappedKeyPairProvider(KeyPair ... pairs) {
        this(GenericUtils.isEmpty(pairs) ? Collections.emptyList() : Arrays.asList(pairs));
    }

    public MappedKeyPairProvider(Collection<? extends KeyPair> pairs) {
        this(MappedKeyPairProvider.mapUniquePairs(pairs));
    }

    public MappedKeyPairProvider(Map<String, KeyPair> pairsMap) {
        this.pairsMap = ValidateUtils.checkNotNullAndNotEmpty(pairsMap, "No pairs map provided", new Object[0]);
    }

    @Override
    public Iterable<KeyPair> loadKeys() {
        return this.pairsMap.values();
    }

    @Override
    public KeyPair loadKey(String type) {
        return this.pairsMap.get(type);
    }

    @Override
    public Iterable<String> getKeyTypes() {
        return this.pairsMap.keySet();
    }

    public String toString() {
        return String.valueOf(this.getKeyTypes());
    }

    public static Map<String, KeyPair> mapUniquePairs(Collection<? extends KeyPair> pairs) {
        if (GenericUtils.isEmpty(pairs)) {
            return Collections.emptyMap();
        }
        TreeMap<String, KeyPair> pairsMap = new TreeMap<String, KeyPair>(String.CASE_INSENSITIVE_ORDER);
        for (KeyPair keyPair : pairs) {
            String keyType = ValidateUtils.checkNotNullAndNotEmpty(KeyUtils.getKeyType(keyPair), "Cannot determine key type");
            KeyPair prev = pairsMap.put(keyType, keyPair);
            ValidateUtils.checkTrue(prev == null, "Multiple keys of type=%s", (Object)keyType);
        }
        return pairsMap;
    }
}

