/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.server.auth.pubkey;

import io.jenkins.cli.shaded.org.apache.sshd.common.RuntimeSshException;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.KeyUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.Session;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.SessionListener;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.logging.AbstractLoggingBean;
import io.jenkins.cli.shaded.org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import io.jenkins.cli.shaded.org.apache.sshd.server.session.ServerSession;
import java.security.PublicKey;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class CachingPublicKeyAuthenticator
extends AbstractLoggingBean
implements PublickeyAuthenticator,
SessionListener {
    protected final PublickeyAuthenticator authenticator;
    protected final Map<Session, Map<PublicKey, Boolean>> cache = new ConcurrentHashMap<Session, Map<PublicKey, Boolean>>();

    public CachingPublicKeyAuthenticator(PublickeyAuthenticator authenticator) {
        this.authenticator = Objects.requireNonNull(authenticator, "No delegate authenticator");
    }

    @Override
    public boolean authenticate(String username, PublicKey key, ServerSession session) {
        Boolean result;
        Map<PublicKey, Boolean> map = this.cache.get(session);
        if (map == null) {
            map = new ConcurrentHashMap<PublicKey, Boolean>();
            this.cache.put(session, map);
            session.addSessionListener(this);
        }
        if ((result = map.get(key)) == null) {
            try {
                result = this.authenticator.authenticate(username, key, session);
            }
            catch (Error e) {
                this.log.warn("authenticate({}@{}) failed ({}) to consult delegate for {} key={}: {}", username, session, e.getClass().getSimpleName(), KeyUtils.getKeyType(key), KeyUtils.getFingerPrint(key), e.getMessage());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("authenticate(" + username + "@" + session + ") delegate failure details", e);
                }
                throw new RuntimeSshException(e);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("authenticate({}@{}) cache result={} for {} key={}", username, session, result, KeyUtils.getKeyType(key), KeyUtils.getFingerPrint(key));
            }
            map.put(key, result);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("authenticate({}@{}) use cached result={} for {} key={}", username, session, result, KeyUtils.getKeyType(key), KeyUtils.getFingerPrint(key));
        }
        return result;
    }

    @Override
    public void sessionCreated(Session session) {
    }

    @Override
    public void sessionEvent(Session session, SessionListener.Event event) {
    }

    @Override
    public void sessionException(Session session, Throwable t) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("sessionException({}) {}: {}", session, t.getClass().getSimpleName(), t.getMessage());
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("sessionException(" + session + ") details", t);
        }
        this.sessionClosed(session);
    }

    @Override
    public void sessionClosed(Session session) {
        Map<PublicKey, Boolean> map = this.cache.remove(session);
        if (map == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("sessionClosed({}) not cached", (Object)session);
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("sessionClosed({}) removed from cache", (Object)session);
        }
        session.removeSessionListener(this);
    }
}

