/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.loader;

import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.loader.AbstractPrivateKeyObfuscator;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.loader.PrivateKeyEncryptionContext;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.security.SecurityUtils;
import java.security.GeneralSecurityException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class AESPrivateKeyObfuscator
extends AbstractPrivateKeyObfuscator {
    public static final String CIPHER_NAME = "AES";
    public static final AESPrivateKeyObfuscator INSTANCE = new AESPrivateKeyObfuscator();

    public AESPrivateKeyObfuscator() {
        super(CIPHER_NAME);
    }

    @Override
    public List<Integer> getSupportedKeySizes() {
        return AESPrivateKeyObfuscator.getAvailableKeyLengths();
    }

    @Override
    public byte[] applyPrivateKeyCipher(byte[] bytes, PrivateKeyEncryptionContext encContext, boolean encryptIt) throws GeneralSecurityException {
        int keyLength = this.resolveKeyLength(encContext);
        byte[] keyValue = this.deriveEncryptionKey(encContext, keyLength / 8);
        return this.applyPrivateKeyCipher(bytes, encContext, keyLength, keyValue, encryptIt);
    }

    @Override
    protected int resolveKeyLength(PrivateKeyEncryptionContext encContext) throws GeneralSecurityException {
        String cipherType = encContext.getCipherType();
        try {
            int keyLength = Integer.parseInt(cipherType);
            List<Integer> sizes = this.getSupportedKeySizes();
            for (Integer s : sizes) {
                if (s != keyLength) continue;
                return keyLength;
            }
            throw new InvalidKeySpecException("Unknown " + this.getCipherName() + " key length: " + cipherType + " - supported: " + sizes);
        }
        catch (NumberFormatException e) {
            throw new InvalidKeySpecException("Bad " + this.getCipherName() + " key length (" + cipherType + "): " + e.getMessage(), e);
        }
    }

    public static List<Integer> getAvailableKeyLengths() {
        return LazyValuesHolder.KEY_LENGTHS;
    }

    private static class LazyValuesHolder {
        private static final List<Integer> KEY_LENGTHS = Collections.unmodifiableList(LazyValuesHolder.detectSupportedKeySizes());

        private LazyValuesHolder() {
        }

        private static List<Integer> detectSupportedKeySizes() {
            ArrayList<Integer> sizes = new ArrayList<Integer>();
            for (int keyLength = 128; keyLength < Short.MAX_VALUE; keyLength += 64) {
                try {
                    byte[] keyAsBytes = new byte[keyLength / 8];
                    SecretKeySpec key = new SecretKeySpec(keyAsBytes, AESPrivateKeyObfuscator.CIPHER_NAME);
                    Cipher c = SecurityUtils.getCipher(AESPrivateKeyObfuscator.CIPHER_NAME);
                    c.init(2, key);
                    sizes.add(keyLength);
                    continue;
                }
                catch (GeneralSecurityException e) {
                    return sizes;
                }
            }
            throw new IllegalStateException("No limit encountered: " + sizes);
        }
    }
}

