/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.io.nio2;

import io.jenkins.cli.shaded.org.apache.sshd.common.FactoryManager;
import io.jenkins.cli.shaded.org.apache.sshd.common.future.DefaultSshFuture;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoConnectFuture;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoConnector;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoHandler;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoSession;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.nio2.Nio2CompletionHandler;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.nio2.Nio2Service;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.nio2.Nio2Session;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;

public class Nio2Connector
extends Nio2Service
implements IoConnector {
    public Nio2Connector(FactoryManager manager, IoHandler handler, AsynchronousChannelGroup group) {
        super(manager, handler, group);
    }

    @Override
    public IoConnectFuture connect(SocketAddress address) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Connecting to {}", (Object)address);
        }
        DefaultIoConnectFuture future = new DefaultIoConnectFuture(address, null);
        AsynchronousSocketChannel channel = null;
        AsynchronousSocketChannel socket = null;
        try {
            AsynchronousChannelGroup group = this.getChannelGroup();
            channel = this.openAsynchronousSocketChannel(address, group);
            socket = this.setSocketOptions(channel);
            Nio2CompletionHandler<Void, Object> completionHandler = ValidateUtils.checkNotNull(this.createConnectionCompletionHandler(future, socket, this.getFactoryManager(), this.getIoHandler()), "No connection completion handler created for %s", (Object)address);
            socket.connect(address, null, completionHandler);
        }
        catch (Throwable exc) {
            Throwable t;
            block12: {
                block11: {
                    t = GenericUtils.peelException(exc);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("connect({}) failed ({}) to schedule connection: {}", address, t.getClass().getSimpleName(), t.getMessage());
                    }
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("connect(" + address + ") connection failure details", t);
                    }
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (IOException err) {
                        if (!this.log.isDebugEnabled()) break block11;
                        this.log.debug("connect({}) - failed ({}) to close socket: {}", address, err.getClass().getSimpleName(), err.getMessage());
                    }
                }
                try {
                    if (channel != null) {
                        channel.close();
                    }
                }
                catch (IOException err) {
                    if (!this.log.isDebugEnabled()) break block12;
                    this.log.debug("connect({}) - failed ({}) to close channel: {}", address, err.getClass().getSimpleName(), err.getMessage());
                }
            }
            future.setException(t);
        }
        return future;
    }

    protected AsynchronousSocketChannel openAsynchronousSocketChannel(SocketAddress address, AsynchronousChannelGroup group) throws IOException {
        return AsynchronousSocketChannel.open(group);
    }

    protected Nio2CompletionHandler<Void, Object> createConnectionCompletionHandler(final IoConnectFuture future, final AsynchronousSocketChannel socket, final FactoryManager manager, final IoHandler handler) {
        return new Nio2CompletionHandler<Void, Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void onCompleted(Void result, Object attachment) {
                block10: {
                    Long sessionId = null;
                    try {
                        Nio2Session session = Nio2Connector.this.createSession(manager, handler, socket);
                        handler.sessionCreated(session);
                        sessionId = session.getId();
                        Nio2Connector.this.sessions.put(sessionId, session);
                        future.setSession(session);
                        if (session.isClosing()) {
                            try {
                                handler.sessionClosed(session);
                                break block10;
                            }
                            finally {
                                Nio2Connector.this.unmapSession(sessionId);
                            }
                        }
                        session.startReading();
                    }
                    catch (Throwable exc) {
                        Throwable t;
                        block11: {
                            t = GenericUtils.peelException(exc);
                            if (Nio2Connector.this.log.isDebugEnabled()) {
                                Nio2Connector.this.log.debug("onCompleted - failed {} to start session: {}", (Object)t.getClass().getSimpleName(), (Object)t.getMessage());
                            }
                            if (Nio2Connector.this.log.isTraceEnabled()) {
                                Nio2Connector.this.log.trace("onCompleted - session creation failure details", t);
                            }
                            try {
                                socket.close();
                            }
                            catch (IOException err) {
                                if (!Nio2Connector.this.log.isDebugEnabled()) break block11;
                                Nio2Connector.this.log.debug("onCompleted - failed {} to close socket: {}", (Object)err.getClass().getSimpleName(), (Object)err.getMessage());
                            }
                        }
                        future.setException(t);
                        Nio2Connector.this.unmapSession(sessionId);
                    }
                }
            }

            @Override
            protected void onFailed(Throwable exc, Object attachment) {
                future.setException(exc);
            }
        };
    }

    protected Nio2Session createSession(FactoryManager manager, IoHandler handler, AsynchronousSocketChannel socket) throws Throwable {
        return new Nio2Session(this, manager, handler, socket);
    }

    public static class DefaultIoConnectFuture
    extends DefaultSshFuture<IoConnectFuture>
    implements IoConnectFuture {
        public DefaultIoConnectFuture(Object id, Object lock) {
            super(id, lock);
        }

        @Override
        public IoSession getSession() {
            Object v = this.getValue();
            return v instanceof IoSession ? (IoSession)v : null;
        }

        @Override
        public Throwable getException() {
            Object v = this.getValue();
            return v instanceof Throwable ? (Throwable)v : null;
        }

        @Override
        public boolean isConnected() {
            return this.getValue() instanceof IoSession;
        }

        @Override
        public void setSession(IoSession session) {
            this.setValue(session);
        }

        @Override
        public void setException(Throwable exception) {
            this.setValue(exception);
        }
    }
}

