/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.signature;

import io.jenkins.cli.shaded.org.apache.sshd.common.signature.AbstractSignature;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;
import java.util.AbstractMap;

public class SignatureRSA
extends AbstractSignature {
    public static final String DEFAULT_ALGORITHM = "SHA1withRSA";
    private int verifierSignatureSize = -1;

    public SignatureRSA() {
        super(DEFAULT_ALGORITHM);
    }

    protected SignatureRSA(String algorithm) {
        super(algorithm);
    }

    protected int getVerifierSignatureSize() {
        return this.verifierSignatureSize;
    }

    @Override
    public void initVerifier(PublicKey key) throws Exception {
        super.initVerifier(key);
        RSAKey rsaKey = ValidateUtils.checkInstanceOf(key, RSAKey.class, "Not an RSA key");
        this.verifierSignatureSize = SignatureRSA.getVerifierSignatureSize(rsaKey);
    }

    public static int getVerifierSignatureSize(RSAKey key) {
        BigInteger modulus = key.getModulus();
        return (modulus.bitLength() + 8 - 1) / 8;
    }

    @Override
    public boolean verify(byte[] sig) throws Exception {
        int expectedSize;
        byte[] data = sig;
        AbstractMap.SimpleImmutableEntry<String, byte[]> encoding = this.extractEncodedSignature(data);
        if (encoding != null) {
            String keyType = (String)encoding.getKey();
            ValidateUtils.checkTrue("ssh-rsa".equals(keyType), "Mismatched key type: %s", (Object)keyType);
            data = (byte[])encoding.getValue();
        }
        ValidateUtils.checkTrue((expectedSize = this.getVerifierSignatureSize()) > 0, "Signature verification size has not been initialized");
        if (data.length < expectedSize) {
            byte[] pad = new byte[expectedSize];
            System.arraycopy(data, 0, pad, pad.length - data.length, data.length);
            data = pad;
        }
        return this.doVerify(data);
    }
}

