/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.file.nativefs;

import io.jenkins.cli.shaded.org.apache.sshd.common.file.FileSystemFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.Session;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.logging.AbstractLoggingBean;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class NativeFileSystemFactory
extends AbstractLoggingBean
implements FileSystemFactory {
    public static final String DEFAULT_USERS_HOME = "/home";
    public static final NativeFileSystemFactory INSTANCE = new NativeFileSystemFactory();
    private boolean createHome;
    private String usersHomeDir = "/home";

    public NativeFileSystemFactory() {
        this(false);
    }

    public NativeFileSystemFactory(boolean createHome) {
        this.createHome = createHome;
    }

    public String getUsersHomeDir() {
        return this.usersHomeDir;
    }

    public void setUsersHomeDir(String usersHomeDir) {
        this.usersHomeDir = ValidateUtils.checkNotNullAndNotEmpty(usersHomeDir, "No users home dir");
    }

    public boolean isCreateHome() {
        return this.createHome;
    }

    public void setCreateHome(boolean createHome) {
        this.createHome = createHome;
    }

    @Override
    public FileSystem createFileSystem(Session session) throws IOException {
        String userName = session.getUsername();
        if (this.isCreateHome()) {
            String homeRoot = this.getUsersHomeDir();
            Path homeDir = Paths.get(homeRoot, userName).normalize().toAbsolutePath();
            if (Files.exists(homeDir, new LinkOption[0])) {
                if (!Files.isDirectory(homeDir, new LinkOption[0])) {
                    throw new NotDirectoryException(homeDir.toString());
                }
            } else {
                Path p = Files.createDirectories(homeDir, new FileAttribute[0]);
                this.log.info("createFileSystem({}) created {}", (Object)session, (Object)p);
            }
        }
        return FileSystems.getDefault();
    }
}

