/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.util.closeable;

import io.jenkins.cli.shaded.org.apache.sshd.common.Closeable;
import io.jenkins.cli.shaded.org.apache.sshd.common.future.CloseFuture;
import io.jenkins.cli.shaded.org.apache.sshd.common.future.SshFutureListener;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.closeable.SimpleCloseable;
import java.util.Collections;
import java.util.Iterator;

public class SequentialCloseable
extends SimpleCloseable {
    private final Iterable<? extends Closeable> closeables;

    public SequentialCloseable(Object id, Object lock, Iterable<? extends Closeable> closeables) {
        super(id, lock);
        this.closeables = closeables == null ? Collections.emptyList() : closeables;
    }

    @Override
    protected void doClose(final boolean immediately) {
        final Iterator<? extends Closeable> iterator = this.closeables.iterator();
        SshFutureListener<CloseFuture> listener = new SshFutureListener<CloseFuture>(){

            @Override
            public void operationComplete(CloseFuture previousFuture) {
                while (iterator.hasNext()) {
                    Closeable c = (Closeable)iterator.next();
                    if (c == null) continue;
                    if (SequentialCloseable.this.log.isTraceEnabled()) {
                        SequentialCloseable.this.log.trace("doClose(" + immediately + ") closing " + c);
                    }
                    CloseFuture nextFuture = c.close(immediately);
                    nextFuture.addListener(this);
                    return;
                }
                if (!iterator.hasNext()) {
                    if (SequentialCloseable.this.log.isDebugEnabled()) {
                        SequentialCloseable.this.log.debug("doClose(" + immediately + ") signal close complete");
                    }
                    SequentialCloseable.this.future.setClosed();
                }
            }
        };
        listener.operationComplete(null);
    }
}

