/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client.session.forward;

import io.jenkins.cli.shaded.org.apache.sshd.client.session.ClientSession;
import io.jenkins.cli.shaded.org.apache.sshd.client.session.ClientSessionHolder;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.net.SshdSocketAddress;
import java.nio.channels.Channel;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class PortForwardingTracker
implements Channel,
ClientSessionHolder {
    protected final AtomicBoolean open = new AtomicBoolean(true);
    private final ClientSession session;
    private final SshdSocketAddress localAddress;
    private final SshdSocketAddress boundAddress;

    protected PortForwardingTracker(ClientSession session, SshdSocketAddress localAddress, SshdSocketAddress boundAddress) {
        this.session = Objects.requireNonNull(session, "No client session provided");
        this.localAddress = Objects.requireNonNull(localAddress, "No local address specified");
        this.boundAddress = Objects.requireNonNull(boundAddress, "No bound address specified");
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    public SshdSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public SshdSocketAddress getBoundAddress() {
        return this.boundAddress;
    }

    @Override
    public ClientSession getClientSession() {
        return this.session;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[session=" + this.getClientSession() + ", localAddress=" + this.getLocalAddress() + ", boundAddress=" + this.getBoundAddress() + ", open=" + this.isOpen() + "]";
    }
}

