/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client.config.keys;

import io.jenkins.cli.shaded.org.apache.sshd.client.config.keys.ClientIdentitiesWatcher;
import io.jenkins.cli.shaded.org.apache.sshd.client.config.keys.ClientIdentity;
import io.jenkins.cli.shaded.org.apache.sshd.client.config.keys.ClientIdentityLoader;
import io.jenkins.cli.shaded.org.apache.sshd.common.NamedResource;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.BuiltinIdentities;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.FilePasswordProvider;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.KeyUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import java.nio.file.Path;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class BuiltinClientIdentitiesWatcher
extends ClientIdentitiesWatcher {
    private final boolean supportedOnly;

    public BuiltinClientIdentitiesWatcher(Path keysFolder, boolean supportedOnly, ClientIdentityLoader loader, FilePasswordProvider provider, boolean strict) {
        this(keysFolder, NamedResource.getNameList(BuiltinIdentities.VALUES), supportedOnly, loader, provider, strict);
    }

    public BuiltinClientIdentitiesWatcher(Path keysFolder, Collection<String> ids, boolean supportedOnly, ClientIdentityLoader loader, FilePasswordProvider provider, boolean strict) {
        this(keysFolder, ids, supportedOnly, GenericUtils.supplierOf(Objects.requireNonNull(loader, "No client identity loader")), GenericUtils.supplierOf(Objects.requireNonNull(provider, "No password provider")), strict);
    }

    public BuiltinClientIdentitiesWatcher(Path keysFolder, boolean supportedOnly, Supplier<ClientIdentityLoader> loader, Supplier<FilePasswordProvider> provider, boolean strict) {
        this(keysFolder, NamedResource.getNameList(BuiltinIdentities.VALUES), supportedOnly, loader, provider, strict);
    }

    public BuiltinClientIdentitiesWatcher(Path keysFolder, Collection<String> ids, boolean supportedOnly, Supplier<ClientIdentityLoader> loader, Supplier<FilePasswordProvider> provider, boolean strict) {
        super(BuiltinClientIdentitiesWatcher.getBuiltinIdentitiesPaths(keysFolder, ids), loader, provider, strict);
        this.supportedOnly = supportedOnly;
    }

    public final boolean isSupportedOnly() {
        return this.supportedOnly;
    }

    @Override
    public Iterable<KeyPair> loadKeys() {
        return this.isSupportedOnly() ? this.loadKeys(this::isSupported) : super.loadKeys();
    }

    private boolean isSupported(KeyPair kp) {
        BuiltinIdentities id = BuiltinIdentities.fromKeyPair(kp);
        if (id != null && id.isSupported()) {
            return true;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("loadKeys - remove unsupported identity={}, key-type={}, key={}", id, KeyUtils.getKeyType(kp), KeyUtils.getFingerPrint(kp.getPublic()));
        }
        return false;
    }

    public static List<Path> getDefaultBuiltinIdentitiesPaths(Path keysFolder) {
        return BuiltinClientIdentitiesWatcher.getBuiltinIdentitiesPaths(keysFolder, NamedResource.getNameList(BuiltinIdentities.VALUES));
    }

    public static List<Path> getBuiltinIdentitiesPaths(Path keysFolder, Collection<String> ids) {
        Objects.requireNonNull(keysFolder, "No keys folder");
        if (GenericUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        ArrayList<Path> paths = new ArrayList<Path>(ids.size());
        for (String id : ids) {
            String fileName = ClientIdentity.getIdentityFileName(id);
            paths.add(keysFolder.resolve(fileName));
        }
        return paths;
    }
}

