/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.config;

import io.jenkins.cli.shaded.org.apache.sshd.common.compression.BuiltinCompressions;
import io.jenkins.cli.shaded.org.apache.sshd.common.compression.Compression;
import io.jenkins.cli.shaded.org.apache.sshd.common.compression.CompressionFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public enum CompressionConfigValue implements CompressionFactory
{
    YES(BuiltinCompressions.zlib),
    NO(BuiltinCompressions.none),
    DELAYED(BuiltinCompressions.delayedZlib);

    public static final Set<CompressionConfigValue> VALUES;
    private final CompressionFactory factory;

    private CompressionConfigValue(CompressionFactory delegate) {
        this.factory = delegate;
    }

    @Override
    public final String getName() {
        return this.factory.getName();
    }

    @Override
    public final Compression create() {
        return (Compression)this.factory.create();
    }

    @Override
    public boolean isSupported() {
        return this.factory.isSupported();
    }

    public final String toString() {
        return this.getName();
    }

    @Override
    public boolean isDelayed() {
        return this.factory.isDelayed();
    }

    @Override
    public boolean isCompressionExecuted() {
        return this.factory.isCompressionExecuted();
    }

    public static CompressionConfigValue fromName(String n) {
        if (GenericUtils.isEmpty(n)) {
            return null;
        }
        for (CompressionConfigValue v : VALUES) {
            if (!n.equalsIgnoreCase(v.name())) continue;
            return v;
        }
        return null;
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(CompressionConfigValue.class));
    }
}

