/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.kex;

import io.jenkins.cli.shaded.org.apache.sshd.common.cipher.ECCurves;
import io.jenkins.cli.shaded.org.apache.sshd.common.digest.Digest;
import io.jenkins.cli.shaded.org.apache.sshd.common.kex.AbstractDH;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.security.SecurityUtils;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.util.Objects;
import javax.crypto.KeyAgreement;

public class ECDH
extends AbstractDH {
    private ECParameterSpec params;
    private ECPoint e;
    private byte[] e_array;
    private ECPoint f;
    private KeyPairGenerator myKpairGen = SecurityUtils.getKeyPairGenerator("EC");
    private KeyAgreement myKeyAgree = SecurityUtils.getKeyAgreement("ECDH");

    public ECDH() throws Exception {
        this((ECParameterSpec)null);
    }

    public ECDH(String curveName) throws Exception {
        this(ValidateUtils.checkNotNull(ECCurves.fromCurveName(curveName), "Unknown curve name: %s", (Object)curveName));
    }

    public ECDH(ECCurves curve) throws Exception {
        this(Objects.requireNonNull(curve, "No known curve instance provided").getParameters());
    }

    public ECDH(ECParameterSpec paramSpec) throws Exception {
        this.params = paramSpec;
    }

    @Override
    public byte[] getE() throws Exception {
        if (this.e == null) {
            Objects.requireNonNull(this.params, "No ECParameterSpec(s)");
            this.myKpairGen.initialize(this.params);
            KeyPair myKpair = this.myKpairGen.generateKeyPair();
            this.myKeyAgree.init(myKpair.getPrivate());
            this.e = ((ECPublicKey)myKpair.getPublic()).getW();
            this.e_array = ECCurves.encodeECPoint(this.e, this.params);
        }
        return this.e_array;
    }

    @Override
    protected byte[] calculateK() throws Exception {
        Objects.requireNonNull(this.params, "No ECParameterSpec(s)");
        KeyFactory myKeyFac = SecurityUtils.getKeyFactory("EC");
        ECPublicKeySpec keySpec = new ECPublicKeySpec(this.f, this.params);
        PublicKey yourPubKey = myKeyFac.generatePublic(keySpec);
        this.myKeyAgree.doPhase(yourPubKey, true);
        return ECDH.stripLeadingZeroes(this.myKeyAgree.generateSecret());
    }

    public void setCurveParameters(ECParameterSpec paramSpec) {
        this.params = paramSpec;
    }

    @Override
    public void setF(byte[] f) {
        Objects.requireNonNull(this.params, "No ECParameterSpec(s)");
        this.f = ECCurves.octetStringToEcPoint(f);
    }

    @Override
    public Digest getHash() throws Exception {
        Objects.requireNonNull(this.params, "No ECParameterSpec(s)");
        ECCurves curve = Objects.requireNonNull(ECCurves.fromCurveParameters(this.params), "Unknown curve parameters");
        return curve.getDigestForParams();
    }
}

