/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.io.mina;

import io.jenkins.cli.shaded.org.apache.mina.core.service.IoProcessor;
import io.jenkins.cli.shaded.org.apache.mina.core.service.IoService;
import io.jenkins.cli.shaded.org.apache.mina.transport.socket.nio.NioSession;
import io.jenkins.cli.shaded.org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import io.jenkins.cli.shaded.org.apache.sshd.common.FactoryManager;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoAcceptor;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoHandler;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.mina.MinaService;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class MinaAcceptor
extends MinaService
implements IoAcceptor,
io.jenkins.cli.shaded.org.apache.mina.core.service.IoHandler {
    protected final AtomicReference<io.jenkins.cli.shaded.org.apache.mina.core.service.IoAcceptor> acceptorHolder = new AtomicReference<Object>(null);
    protected int backlog = 0;
    protected boolean reuseAddress = true;

    public MinaAcceptor(FactoryManager manager, IoHandler handler, IoProcessor<NioSession> ioProcessor) {
        super(manager, handler, ioProcessor);
        this.backlog = manager.getIntProperty("socket-backlog", 0);
        this.reuseAddress = manager.getBooleanProperty("socket-reuseaddr", true);
    }

    protected io.jenkins.cli.shaded.org.apache.mina.core.service.IoAcceptor createAcceptor() {
        NioSocketAcceptor acceptor = new NioSocketAcceptor(this.ioProcessor);
        acceptor.setCloseOnDeactivation(false);
        acceptor.setReuseAddress(this.reuseAddress);
        acceptor.setBacklog(this.backlog);
        this.configure(acceptor.getSessionConfig());
        return acceptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected io.jenkins.cli.shaded.org.apache.mina.core.service.IoAcceptor getAcceptor() {
        io.jenkins.cli.shaded.org.apache.mina.core.service.IoAcceptor acceptor;
        AtomicReference<io.jenkins.cli.shaded.org.apache.mina.core.service.IoAcceptor> atomicReference = this.acceptorHolder;
        synchronized (atomicReference) {
            acceptor = this.acceptorHolder.get();
            if (acceptor != null) {
                return acceptor;
            }
            acceptor = this.createAcceptor();
            acceptor.setHandler((io.jenkins.cli.shaded.org.apache.mina.core.service.IoHandler)this);
            this.acceptorHolder.set(acceptor);
        }
        this.log.debug("Created IoAcceptor");
        return acceptor;
    }

    @Override
    protected IoService getIoService() {
        return this.getAcceptor();
    }

    @Override
    public void bind(Collection<? extends SocketAddress> addresses) throws IOException {
        io.jenkins.cli.shaded.org.apache.mina.core.service.IoAcceptor acceptor = this.getAcceptor();
        acceptor.bind(addresses);
    }

    @Override
    public void bind(SocketAddress address) throws IOException {
        io.jenkins.cli.shaded.org.apache.mina.core.service.IoAcceptor acceptor = this.getAcceptor();
        acceptor.bind(address);
    }

    @Override
    public void unbind() {
        io.jenkins.cli.shaded.org.apache.mina.core.service.IoAcceptor acceptor = this.getAcceptor();
        acceptor.unbind();
    }

    @Override
    public void unbind(Collection<? extends SocketAddress> addresses) {
        io.jenkins.cli.shaded.org.apache.mina.core.service.IoAcceptor acceptor = this.getAcceptor();
        acceptor.unbind(addresses);
    }

    @Override
    public void unbind(SocketAddress address) {
        io.jenkins.cli.shaded.org.apache.mina.core.service.IoAcceptor acceptor = this.getAcceptor();
        acceptor.unbind(address);
    }

    @Override
    public Set<SocketAddress> getBoundAddresses() {
        io.jenkins.cli.shaded.org.apache.mina.core.service.IoAcceptor acceptor = this.getAcceptor();
        return acceptor.getLocalAddresses();
    }
}

