/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import java.io.ByteArrayInputStream;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.util.security.SecurityUtils;

public class PrivateKeyProvider {
    private List<KeyPair> privateKeys = new ArrayList<KeyPair>();
    private static final Logger LOGGER = Logger.getLogger(PrivateKeyProvider.class.getName());

    public List<KeyPair> getKeys() {
        return Collections.unmodifiableList(this.privateKeys);
    }

    public boolean hasKeys() {
        return !this.privateKeys.isEmpty();
    }

    public boolean readFromDefaultLocations() {
        File home = new File(System.getProperty("user.home"));
        boolean read = false;
        for (String path : new String[]{".ssh/id_rsa", ".ssh/id_dsa", ".ssh/identity"}) {
            File key = new File(home, path);
            if (!key.exists()) continue;
            try {
                this.readFrom(key);
                read = true;
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Failed to load " + key, e);
            }
            catch (GeneralSecurityException e) {
                LOGGER.log(Level.FINE, "Failed to load " + key, e);
            }
        }
        return read;
    }

    public void readFrom(File keyFile) throws IOException, GeneralSecurityException {
        String password = PrivateKeyProvider.isPemEncrypted(keyFile) ? PrivateKeyProvider.askForPasswd(keyFile.getCanonicalPath()) : null;
        this.privateKeys.add(PrivateKeyProvider.loadKey(keyFile, password));
    }

    private static boolean isPemEncrypted(File f) throws IOException {
        return PrivateKeyProvider.readPemFile(f).contains("4,ENCRYPTED");
    }

    private static String askForPasswd(String filePath) {
        Console cons = System.console();
        String passwd = null;
        if (cons != null) {
            char[] p = cons.readPassword("%s", "Enter passphrase for " + filePath + ":");
            passwd = String.valueOf(p);
        }
        return passwd;
    }

    public static KeyPair loadKey(File f, String passwd) throws IOException, GeneralSecurityException {
        return PrivateKeyProvider.loadKey(PrivateKeyProvider.readPemFile(f), passwd);
    }

    /*
     * Exception decompiling
     */
    private static String readPemFile(File f) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static KeyPair loadKey(String pemString, String passwd) throws IOException, GeneralSecurityException {
        return SecurityUtils.loadKeyPairIdentity((String)"key", (InputStream)new ByteArrayInputStream(pemString.getBytes(StandardCharsets.UTF_8)), (FilePasswordProvider)FilePasswordProvider.of((String)passwd));
    }
}

