/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import com.trilead.ssh2.crypto.PEMDecoder;
import com.trilead.ssh2.signature.DSAPrivateKey;
import com.trilead.ssh2.signature.RSAPrivateKey;
import hudson.cli.CLIConnectionFactory;
import hudson.cli.CliEntryPoint;
import hudson.cli.CliPort;
import hudson.cli.Connection;
import hudson.cli.FullDuplexHttpStream;
import hudson.cli.client.Messages;
import hudson.remoting.Channel;
import hudson.remoting.PingThread;
import hudson.remoting.Pipe;
import hudson.remoting.RemoteInputStream;
import hudson.remoting.RemoteOutputStream;
import hudson.remoting.SocketInputStream;
import hudson.remoting.SocketOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.Console;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.spec.SecretKeySpec;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLI {
    private final ExecutorService pool;
    private final Channel channel;
    private final CliEntryPoint entryPoint;
    private final boolean ownsPool;
    private final List<Closeable> closables = new ArrayList<Closeable>();
    private final String httpsProxyTunnel;
    private final String authorization;
    private static final Logger LOGGER = Logger.getLogger(CLI.class.getName());

    public CLI(URL jenkins) throws IOException, InterruptedException {
        this(jenkins, null);
    }

    public CLI(URL jenkins, ExecutorService exec) throws IOException, InterruptedException {
        this(jenkins, exec, null);
    }

    public CLI(URL jenkins, ExecutorService exec, String httpsProxyTunnel) throws IOException, InterruptedException {
        this(new CLIConnectionFactory().url(jenkins).executorService(exec).httpsProxyTunnel(httpsProxyTunnel));
    }

    CLI(CLIConnectionFactory factory) throws IOException, InterruptedException {
        URL jenkins = factory.jenkins;
        this.httpsProxyTunnel = factory.httpsProxyTunnel;
        this.authorization = factory.authorization;
        ExecutorService exec = factory.exec;
        String url = jenkins.toExternalForm();
        if (!url.endsWith("/")) {
            url = url + '/';
        }
        this.ownsPool = exec == null;
        this.pool = exec != null ? exec : Executors.newCachedThreadPool();
        Channel channel = null;
        CliPort clip = this.getCliTcpPort(url);
        if (clip != null) {
            try {
                channel = this.connectViaCliPort(jenkins, clip);
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Failed to connect via CLI port. Falling back to HTTP", e);
            }
        }
        if (channel == null) {
            channel = this.connectViaHttp(url);
        }
        this.channel = channel;
        this.entryPoint = (CliEntryPoint)channel.waitForRemoteProperty((Object)CliEntryPoint.class.getName());
        if (this.entryPoint.protocolVersion() != 1) {
            throw new IOException(Messages.CLI_VersionMismatch());
        }
    }

    private Channel connectViaHttp(String url) throws IOException {
        LOGGER.fine("Trying to connect to " + url + " via HTTP");
        url = url + "cli";
        URL jenkins = new URL(url);
        FullDuplexHttpStream con = new FullDuplexHttpStream(jenkins, this.authorization);
        Channel ch = new Channel("Chunked connection to " + jenkins, this.pool, con.getInputStream(), con.getOutputStream());
        long interval = 15000L;
        long timeout = 11250L;
        new PingThread(ch, 11250L, 15000L){

            protected void onDead() {
            }
        }.start();
        return ch;
    }

    private Channel connectViaCliPort(URL jenkins, CliPort clip) throws IOException {
        SocketOutputStream out;
        Socket s;
        LOGGER.fine("Trying to connect directly via TCP/IP to " + clip.endpoint);
        if (this.httpsProxyTunnel != null) {
            String[] tokens = this.httpsProxyTunnel.split(":");
            s = new Socket(tokens[0], Integer.parseInt(tokens[1]));
            PrintStream o = new PrintStream(s.getOutputStream());
            o.print("CONNECT " + clip.endpoint.getHostName() + ":" + clip.endpoint.getPort() + " HTTP/1.0\r\n\r\n");
            ByteArrayOutputStream rsp = new ByteArrayOutputStream();
            while (!rsp.toString().endsWith("\r\n\r\n")) {
                int ch = s.getInputStream().read();
                if (ch < 0) {
                    throw new IOException("Failed to read the HTTP proxy response: " + rsp);
                }
                rsp.write(ch);
            }
            String head = new BufferedReader(new StringReader(rsp.toString())).readLine();
            if (!head.startsWith("HTTP/1.0 200 ")) {
                throw new IOException("Failed to establish a connection through HTTP proxy: " + rsp);
            }
            out = new SocketOutputStream(s){

                public void close() throws IOException {
                }
            };
        } else {
            s = new Socket();
            s.connect(clip.endpoint, 3000);
            out = new SocketOutputStream(s);
        }
        this.closables.add(new Closeable(){

            public void close() throws IOException {
                s.close();
            }
        });
        Connection c = new Connection((InputStream)new SocketInputStream(s), (OutputStream)out);
        switch (clip.version) {
            case 1: {
                DataOutputStream dos = new DataOutputStream(s.getOutputStream());
                dos.writeUTF("Protocol:CLI-connect");
                break;
            }
            case 2: {
                DataInputStream dis = new DataInputStream(s.getInputStream());
                DataOutputStream dos = new DataOutputStream(s.getOutputStream());
                dos.writeUTF("Protocol:CLI2-connect");
                String greeting = dis.readUTF();
                if (!greeting.equals("Welcome")) {
                    throw new IOException("Handshaking failed: " + greeting);
                }
                try {
                    byte[] secret = c.diffieHellman(false).generateSecret();
                    SecretKeySpec sessionKey = new SecretKeySpec(Connection.fold(secret, 16), "AES");
                    c = c.encryptConnection(sessionKey, "AES/CFB8/NoPadding");
                    byte[] signature = c.readByteArray();
                    if (clip.identity != null) {
                        Signature verifier = Signature.getInstance("SHA1withRSA");
                        verifier.initVerify(clip.getIdentity());
                        verifier.update(secret);
                        if (!verifier.verify(signature)) {
                            throw new IOException("Server identity signature validation failed.");
                        }
                    }
                    break;
                }
                catch (GeneralSecurityException e) {
                    throw (IOException)new IOException("Failed to negotiate transport security").initCause(e);
                }
            }
        }
        return new Channel("CLI connection to " + jenkins, this.pool, (InputStream)new BufferedInputStream(c.in), (OutputStream)new BufferedOutputStream(c.out));
    }

    private CliPort getCliTcpPort(String url) throws IOException {
        String p1;
        URL _url = new URL(url);
        if (_url.getHost() == null || _url.getHost().length() == 0) {
            throw new IOException("Invalid URL: " + url);
        }
        URLConnection head = _url.openConnection();
        try {
            head.connect();
        }
        catch (IOException e) {
            throw (IOException)new IOException("Failed to connect to " + url).initCause(e);
        }
        String h = head.getHeaderField("X-Jenkins-CLI-Host");
        if (h == null) {
            h = head.getURL().getHost();
        }
        if ((p1 = head.getHeaderField("X-Jenkins-CLI-Port")) == null) {
            p1 = head.getHeaderField("X-Hudson-CLI-Port");
        }
        String p2 = head.getHeaderField("X-Jenkins-CLI2-Port");
        String identity = head.getHeaderField("X-Instance-Identity");
        this.flushURLConnection(head);
        if (p1 == null && p2 == null) {
            return null;
        }
        if (p2 != null) {
            return new CliPort(new InetSocketAddress(h, Integer.parseInt(p2)), identity, 2);
        }
        return new CliPort(new InetSocketAddress(h, Integer.parseInt(p1)), identity, 1);
    }

    private void flushURLConnection(URLConnection conn) {
        byte[] buf = new byte[1024];
        try {
            InputStream is = conn.getInputStream();
            while (is.read(buf) > 0) {
            }
            is.close();
        }
        catch (IOException e) {
            try {
                InputStream es = ((HttpURLConnection)conn).getErrorStream();
                while (es.read(buf) > 0) {
                }
                es.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
    }

    public void close() throws IOException, InterruptedException {
        this.channel.close();
        this.channel.join();
        if (this.ownsPool) {
            this.pool.shutdown();
        }
        for (Closeable c : this.closables) {
            c.close();
        }
    }

    public int execute(List<String> args, InputStream stdin, OutputStream stdout, OutputStream stderr) {
        return this.entryPoint.main(args, Locale.getDefault(), (InputStream)new RemoteInputStream(stdin), (OutputStream)new RemoteOutputStream(stdout), (OutputStream)new RemoteOutputStream(stderr));
    }

    public int execute(List<String> args) {
        return this.execute(args, System.in, System.out, System.err);
    }

    public int execute(String ... args) {
        return this.execute(Arrays.asList(args));
    }

    public boolean hasCommand(String name) {
        return this.entryPoint.hasCommand(name);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void upgrade() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (this.execute(Arrays.asList("groovy", "="), new ByteArrayInputStream("hudson.remoting.Channel.current().setRestricted(false)".getBytes()), out, out) != 0) {
            throw new SecurityException(out.toString());
        }
    }

    public static void main(String[] _args) throws Exception {
        System.exit(CLI._main(_args));
    }

    /*
     * Exception decompiling
     */
    public static int _main(String[] _args) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String computeVersion() {
        Properties props = new Properties();
        try {
            InputStream is = CLI.class.getResourceAsStream("/jenkins/cli/jenkins-cli-version.properties");
            if (is != null) {
                props.load(is);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return props.getProperty("version", "?");
    }

    public static KeyPair loadKey(File f, String passwd) throws IOException, GeneralSecurityException {
        return CLI.loadKey(CLI.readPemFile(f), passwd);
    }

    public static KeyPair loadKey(File f) throws IOException, GeneralSecurityException {
        return CLI.loadKey(f, null);
    }

    private static String readPemFile(File f) throws IOException {
        DataInputStream dis = new DataInputStream(new FileInputStream(f));
        byte[] bytes = new byte[(int)f.length()];
        dis.readFully(bytes);
        dis.close();
        return new String(bytes);
    }

    public static KeyPair loadKey(String pemString, String passwd) throws IOException, GeneralSecurityException {
        Object key = PEMDecoder.decode((char[])pemString.toCharArray(), (String)passwd);
        if (key instanceof RSAPrivateKey) {
            RSAPrivateKey x = (RSAPrivateKey)key;
            return x.toJCEKeyPair();
        }
        if (key instanceof DSAPrivateKey) {
            DSAPrivateKey x = (DSAPrivateKey)key;
            KeyFactory kf = KeyFactory.getInstance("DSA");
            return new KeyPair(kf.generatePublic(new DSAPublicKeySpec(x.getY(), x.getP(), x.getQ(), x.getG())), kf.generatePrivate(new DSAPrivateKeySpec(x.getX(), x.getP(), x.getQ(), x.getG())));
        }
        throw new UnsupportedOperationException("Unrecognizable key format: " + key);
    }

    public static KeyPair loadKey(String pemString) throws IOException, GeneralSecurityException {
        return CLI.loadKey(pemString, null);
    }

    private static KeyPair tryEncryptedFile(File f) throws IOException, GeneralSecurityException {
        KeyPair kp = null;
        if (CLI.isPemEncrypted(f)) {
            String passwd = CLI.askForPasswd(f.getCanonicalPath());
            kp = CLI.loadKey(f, passwd);
        }
        return kp;
    }

    private static boolean isPemEncrypted(File f) throws IOException {
        String pemString = CLI.readPemFile(f);
        return pemString.contains("4,ENCRYPTED");
    }

    @IgnoreJRERequirement
    private static String askForPasswd(String filePath) {
        try {
            Console cons = System.console();
            String passwd = null;
            if (cons != null) {
                char[] p = cons.readPassword("%s", "Enter passphrase for " + filePath + ":");
                passwd = String.valueOf(p);
            }
            return passwd;
        }
        catch (LinkageError e) {
            throw new Error("Your private key is encrypted, but we need Java6 to ask you password safely", e);
        }
    }

    private static void addDefaultPrivateKeyLocations(List<KeyPair> keyFileCandidates) {
        File home = new File(System.getProperty("user.home"));
        for (String path : new String[]{".ssh/id_rsa", ".ssh/id_dsa", ".ssh/identity"}) {
            File key = new File(home, path);
            if (!key.exists()) continue;
            try {
                keyFileCandidates.add(CLI.loadKey(key));
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Failed to load " + key, e);
            }
            catch (GeneralSecurityException e) {
                LOGGER.log(Level.FINE, "Failed to load " + key, e);
            }
        }
    }

    public PublicKey authenticate(Iterable<KeyPair> privateKeys) throws IOException, GeneralSecurityException {
        Pipe c2s = Pipe.createLocalToRemote();
        Pipe s2c = Pipe.createRemoteToLocal();
        this.entryPoint.authenticate("ssh", c2s, s2c);
        Connection c = new Connection(s2c.getIn(), c2s.getOut());
        try {
            byte[] sharedSecret = c.diffieHellman(false).generateSecret();
            PublicKey serverIdentity = c.verifyIdentity(sharedSecret);
            for (KeyPair key : privateKeys) {
                c.proveIdentity(sharedSecret, key);
                if (!c.readBoolean()) continue;
                PublicKey publicKey = serverIdentity;
                return publicKey;
            }
            if (privateKeys.iterator().hasNext()) {
                throw new GeneralSecurityException("Authentication failed. No private key accepted.");
            }
            throw new GeneralSecurityException("No private key is available for use in authentication");
        }
        finally {
            c.close();
        }
    }

    public PublicKey authenticate(KeyPair key) throws IOException, GeneralSecurityException {
        return this.authenticate(Collections.singleton(key));
    }

    private static void printUsage(String msg) {
        if (msg != null) {
            System.out.println(msg);
        }
        System.err.println(Messages.CLI_Usage());
    }
}

