/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.control.connection;

import com.alibaba.nacos.common.executor.ExecutorFactory;
import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.control.Loggers;
import com.alibaba.nacos.plugin.control.connection.ConnectionMetricsCollector;
import com.alibaba.nacos.plugin.control.connection.request.ConnectionCheckRequest;
import com.alibaba.nacos.plugin.control.connection.response.ConnectionCheckResponse;
import com.alibaba.nacos.plugin.control.connection.rule.ConnectionControlRule;
import com.alibaba.nacos.plugin.control.rule.parser.ConnectionControlRuleParser;
import com.alibaba.nacos.plugin.control.rule.parser.NacosConnectionControlRuleParser;
import com.alibaba.nacos.plugin.control.rule.storage.RuleStorageProxy;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public abstract class ConnectionControlManager {
    private final ConnectionControlRuleParser connectionControlRuleParser;
    protected ConnectionControlRule connectionControlRule;
    protected Collection<ConnectionMetricsCollector> metricsCollectorList = NacosServiceLoader.load(ConnectionMetricsCollector.class);
    private ScheduledExecutorService executorService;

    public ConnectionControlManager() {
        Loggers.CONTROL.info("Load connection metrics collector,size={},{}", (Object)this.metricsCollectorList.size(), this.metricsCollectorList);
        this.connectionControlRuleParser = this.buildConnectionControlRuleParser();
        this.initConnectionRule();
        if (!this.metricsCollectorList.isEmpty()) {
            this.initExecuteService();
            this.startConnectionMetricsReport();
        }
    }

    public abstract String getName();

    protected ConnectionControlRuleParser buildConnectionControlRuleParser() {
        return new NacosConnectionControlRuleParser();
    }

    public ConnectionControlRuleParser getConnectionControlRuleParser() {
        return this.connectionControlRuleParser;
    }

    private void initExecuteService() {
        this.executorService = ExecutorFactory.newSingleScheduledExecutorService(r -> {
            Thread thread = new Thread(r, "nacos.plugin.control.connection.reporter");
            thread.setDaemon(true);
            return thread;
        });
    }

    private void initConnectionRule() {
        RuleStorageProxy ruleStorageProxy = RuleStorageProxy.getInstance();
        String localRuleContent = ruleStorageProxy.getLocalDiskStorage().getConnectionRule();
        if (StringUtils.isNotBlank((String)localRuleContent)) {
            Loggers.CONTROL.info("Found local disk connection rule content on start up,value  ={}", (Object)localRuleContent);
        } else if (ruleStorageProxy.getExternalStorage() != null && ruleStorageProxy.getExternalStorage().getConnectionRule() != null && StringUtils.isNotBlank((String)(localRuleContent = ruleStorageProxy.getExternalStorage().getConnectionRule()))) {
            Loggers.CONTROL.info("Found persist disk connection rule content on start up ,value  ={}", (Object)localRuleContent);
        }
        if (StringUtils.isNotBlank((String)localRuleContent)) {
            this.connectionControlRule = (ConnectionControlRule)this.connectionControlRuleParser.parseRule(localRuleContent);
            Loggers.CONTROL.info("init connection rule end");
        } else {
            Loggers.CONTROL.info("No connection rule content found ,use default empty rule ");
            this.connectionControlRule = new ConnectionControlRule();
        }
    }

    private void startConnectionMetricsReport() {
        this.executorService.scheduleWithFixedDelay(new ConnectionMetricsReporter(), 0L, 3000L, TimeUnit.MILLISECONDS);
    }

    public ConnectionControlRule getConnectionLimitRule() {
        return this.connectionControlRule;
    }

    public abstract void applyConnectionLimitRule(ConnectionControlRule var1);

    public abstract ConnectionCheckResponse check(ConnectionCheckRequest var1);

    class ConnectionMetricsReporter
    implements Runnable {
        ConnectionMetricsReporter() {
        }

        @Override
        public void run() {
            Map<String, Integer> metricsTotalCount = ConnectionControlManager.this.metricsCollectorList.stream().collect(Collectors.toMap(ConnectionMetricsCollector::getName, ConnectionMetricsCollector::getTotalCount));
            int totalCount = metricsTotalCount.values().stream().mapToInt(Integer::intValue).sum();
            Loggers.CONNECTION.info("ConnectionMetrics, totalCount = {}, detail = {}", (Object)totalCount, metricsTotalCount);
        }
    }
}

