/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.controller;

import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.model.RestResultUtils;
import com.alibaba.nacos.console.paramcheck.ConsoleDefaultHttpParamExtractor;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.alibaba.nacos.sys.module.ModuleState;
import com.alibaba.nacos.sys.module.ModuleStateHolder;
import com.alibaba.nacos.sys.utils.DiskUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/console/server"})
@ExtractorManager.Extractor(httpExtractor=ConsoleDefaultHttpParamExtractor.class)
public class ServerStateController {
    private static final String ANNOUNCEMENT_FILE = "announcement.conf";
    private static final String GUIDE_FILE = "console-guide.conf";

    @GetMapping(value={"/state"})
    public ResponseEntity<Map<String, String>> serverState() {
        HashMap serverState = new HashMap(4);
        for (ModuleState each : ModuleStateHolder.getInstance().getAllModuleStates()) {
            each.getStates().forEach((s, o) -> serverState.put(s, null == o ? null : o.toString()));
        }
        return ResponseEntity.ok().body(serverState);
    }

    @GetMapping(value={"/announcement"})
    public RestResult<String> getAnnouncement(@RequestParam(required=false, name="language", defaultValue="zh-CN") String language) {
        String file = ANNOUNCEMENT_FILE.substring(0, ANNOUNCEMENT_FILE.length() - 5) + "_" + language + ".conf";
        if (file.contains("..") || file.contains("/") || file.contains("\\")) {
            throw new IllegalArgumentException("Invalid filename");
        }
        File announcementFile = new File(EnvUtil.getConfPath(), file);
        String announcement = null;
        if (announcementFile.exists() && announcementFile.isFile()) {
            announcement = DiskUtils.readFile((File)announcementFile);
        }
        return RestResultUtils.success(announcement);
    }

    @GetMapping(value={"/guide"})
    public RestResult<String> getConsoleUiGuide() {
        File guideFile = new File(EnvUtil.getConfPath(), GUIDE_FILE);
        String guideInformation = null;
        if (guideFile.exists() && guideFile.isFile()) {
            guideInformation = DiskUtils.readFile((File)guideFile);
        }
        return RestResultUtils.success(guideInformation);
    }
}

