/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.largeobject;

import com.kingbase8.largeobject.LargeObject;
import com.kingbase8.util.TraceLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.logging.Level;

public class BlobOutputStream
extends OutputStream {
    private int bposition;
    private byte[] _buf;
    private int bsize;
    private LargeObject largeObject;

    public BlobOutputStream(LargeObject largeObject) {
        this(largeObject, 1024);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public BlobOutputStream(LargeObject largeObject, int bsizeT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.largeObject = largeObject;
        this.bsize = bsizeT;
        this._buf = new byte[bsizeT];
        this.bposition = 0;
    }

    @Override
    public void write(int bT) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.bposition >= this.bsize) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.largeObject.write(this._buf);
                this.bposition = 0;
            }
            this._buf[this.bposition++] = (byte)bT;
        }
        catch (SQLException se) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IOException(se.toString());
        }
    }

    @Override
    public void write(byte[] _buf, int off, int leng) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.bposition > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.flush();
            }
            if (off == 0 && leng == _buf.length) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.largeObject.write(_buf);
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.largeObject.write(_buf, off, leng);
            }
        }
        catch (SQLException se) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IOException(se.toString());
        }
    }

    @Override
    public void flush() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.bposition > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.largeObject.write(this._buf, 0, this.bposition);
            }
            this.bposition = 0;
        }
        catch (SQLException se) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IOException(se.toString());
        }
    }

    private void checkIsClosed_() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.largeObject == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IOException("BlobOutputStream is closed");
        }
    }

    @Override
    public void close() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.largeObject != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                this.flush();
                this.largeObject.close();
                this.largeObject = null;
            }
            catch (SQLException se) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new IOException(se.toString());
            }
        }
    }
}

