/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.boot.starter.lock.core.strategy.impl;

import org.apache.commons.lang3.StringUtils;
import org.jeecg.boot.starter.lock.core.strategy.RedissonConfigStrategy;
import org.jeecg.boot.starter.lock.prop.RedissonProperties;
import org.redisson.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneRedissonConfigStrategyImpl
implements RedissonConfigStrategy {
    private static final Logger log = LoggerFactory.getLogger(StandaloneRedissonConfigStrategyImpl.class);

    @Override
    public Config createRedissonConfig(RedissonProperties redissonProperties) {
        Config config = new Config();
        try {
            String address = redissonProperties.getAddress();
            String password = redissonProperties.getPassword();
            int database = redissonProperties.getDatabase();
            String redisAddr = "redis://" + address;
            config.useSingleServer().setAddress(redisAddr);
            config.useSingleServer().setDatabase(database);
            if (StringUtils.isNotBlank((CharSequence)password)) {
                config.useSingleServer().setPassword(password);
            }
            log.info("\u521d\u59cb\u5316Redisson\u5355\u673a\u914d\u7f6e,\u8fde\u63a5\u5730\u5740:" + address);
        }
        catch (Exception e) {
            log.error("\u5355\u673aRedisson\u521d\u59cb\u5316\u9519\u8bef", (Throwable)e);
            e.printStackTrace();
        }
        return config;
    }
}

