/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.config;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import com.alibaba.fastjson.support.springfox.SwaggerJsonSerializer;
import feign.Feign;
import feign.Logger;
import feign.RequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.form.spring.SpringFormEncoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.SortedMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.jeecg.common.config.TenantContext;
import org.jeecg.common.config.mqtoken.UserTokenContext;
import org.jeecg.common.util.PathMatcherUtil;
import org.jeecg.config.JeecgCloudBaseConfig;
import org.jeecg.starter.cloud.util.HttpUtils;
import org.jeecg.starter.cloud.util.SignUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.FeignAutoConfiguration;
import org.springframework.cloud.openfeign.support.SpringDecoder;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@ConditionalOnClass(value={Feign.class})
@AutoConfigureBefore(value={FeignAutoConfiguration.class})
@Configuration
public class FeignConfig {
    private static final Logger log = LoggerFactory.getLogger(FeignConfig.class);
    @Resource
    JeecgCloudBaseConfig jeecgCloudBaseConfig;
    public static final String X_ACCESS_TOKEN = "X-Access-Token";
    public static final String X_SIGN = "X-Sign";
    public static final String X_TIMESTAMP = "X-TIMESTAMP";
    public static final String TENANT_ID = "X-Tenant-Id";

    @Bean
    public RequestInterceptor requestInterceptor() {
        return requestTemplate -> {
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (null != attributes) {
                HttpServletRequest request = attributes.getRequest();
                log.debug("Feign request: {}", (Object)request.getRequestURI());
                String token = request.getHeader(X_ACCESS_TOKEN);
                if ((token == null || "".equals(token)) && StringUtils.isEmpty((CharSequence)(token = request.getParameter("token")))) {
                    token = UserTokenContext.getToken();
                }
                log.debug("Feign Login Request token: {}", (Object)token);
                requestTemplate.header(X_ACCESS_TOKEN, new String[]{token});
                String tenantId = request.getHeader(TENANT_ID);
                if (tenantId == null || "".equals(tenantId)) {
                    tenantId = request.getParameter(TENANT_ID);
                }
                log.debug("Feign Login Request tenantId: {}", (Object)tenantId);
                requestTemplate.header(TENANT_ID, new String[]{tenantId});
            } else {
                String token = UserTokenContext.getToken();
                log.debug("Feign no Login token: {}", (Object)token);
                requestTemplate.header(X_ACCESS_TOKEN, new String[]{token});
                String tenantId = TenantContext.getTenant();
                log.debug("Feign no Login tenantId: {}", (Object)tenantId);
                requestTemplate.header(TENANT_ID, new String[]{tenantId});
            }
            String signUrls = this.jeecgCloudBaseConfig.getSignUrls();
            List<String> signUrlsArray = null;
            signUrlsArray = StringUtils.isNotBlank((CharSequence)signUrls) ? Arrays.asList(signUrls.split(",")) : Arrays.asList(PathMatcherUtil.SIGN_URL_LIST);
            if (PathMatcherUtil.matches(signUrlsArray, (String)requestTemplate.path())) {
                try {
                    log.debug("============================ [begin] fegin starter url ============================");
                    log.debug(requestTemplate.path());
                    log.debug(requestTemplate.method());
                    String queryLine = requestTemplate.queryLine();
                    if (queryLine != null && queryLine.startsWith("?")) {
                        queryLine = queryLine.substring(1);
                    }
                    log.debug(queryLine);
                    if (requestTemplate.body() != null) {
                        log.debug(new String(requestTemplate.body()));
                    }
                    SortedMap<String, String> allParams = HttpUtils.getAllParams(requestTemplate.path(), queryLine, requestTemplate.body(), requestTemplate.method());
                    String sign = SignUtil.getParamsSign(allParams);
                    log.info("\u3010\u5fae\u670d\u52a1\u3011 Feign request params sign: {}", (Object)sign);
                    log.debug("============================ [end] fegin starter url ============================");
                    requestTemplate.header(X_SIGN, new String[]{sign});
                    requestTemplate.header(X_TIMESTAMP, new String[]{String.valueOf(System.currentTimeMillis())});
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    @Bean
    Logger.Level feignLoggerLevel() {
        return Logger.Level.FULL;
    }

    @Bean
    @Primary
    @Scope(value="prototype")
    public Encoder multipartFormEncoder(ObjectFactory<HttpMessageConverters> messageConverters) {
        return new SpringFormEncoder((Encoder)new SpringEncoder(messageConverters));
    }

    @Bean
    public Encoder feignEncoder() {
        return new SpringEncoder(this.feignHttpMessageConverter());
    }

    @Bean
    public Decoder feignDecoder() {
        return new SpringDecoder(this.feignHttpMessageConverter());
    }

    private ObjectFactory<HttpMessageConverters> feignHttpMessageConverter() {
        HttpMessageConverters httpMessageConverters = new HttpMessageConverters(new HttpMessageConverter[]{this.getFastJsonConverter()});
        return () -> httpMessageConverters;
    }

    private FastJsonHttpMessageConverter getFastJsonConverter() {
        FastJsonHttpMessageConverter converter = new FastJsonHttpMessageConverter();
        ArrayList<MediaType> supportedMediaTypes = new ArrayList<MediaType>();
        MediaType mediaTypeJson = MediaType.valueOf((String)"application/json");
        supportedMediaTypes.add(mediaTypeJson);
        converter.setSupportedMediaTypes(supportedMediaTypes);
        FastJsonConfig config = new FastJsonConfig();
        config.getSerializeConfig().put(JSON.class, (ObjectSerializer)new SwaggerJsonSerializer());
        config.setSerializerFeatures(new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
        converter.setFastJsonConfig(config);
        return converter;
    }
}

