/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.customizer.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jdbi.v3.sqlobject.customizer.DefineList;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;
import org.jdbi.v3.sqlobject.internal.ParameterUtil;

public final class DefineListFactory
implements SqlStatementCustomizerFactory {
    @Override
    public SqlStatementParameterCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Type type) {
        DefineList d = (DefineList)annotation;
        String name = ParameterUtil.findParameterName(d.value(), param).orElseThrow(() -> new UnsupportedOperationException("A @DefineList parameter was not given a name, and parameter name data is not present in the class file, for: " + String.valueOf(param.getDeclaringExecutable()) + "::" + String.valueOf(param)));
        return (stmt, arg) -> {
            List<Object> argsList;
            if (arg instanceof List) {
                List<Object> list;
                argsList = list = (List<Object>)arg;
            } else if (arg instanceof Object[]) {
                Object[] list = (Object[])arg;
                argsList = Arrays.asList(list);
            } else {
                if (arg == null) {
                    throw new IllegalArgumentException("A null object was passed as a @DefineList parameter. @DefineList is only supported on List and array arguments");
                }
                throw new IllegalArgumentException("A " + String.valueOf(arg.getClass()) + " object was passed as a @DefineList parameter. @DefineList is only supported on List and array arguments");
            }
            if (argsList.isEmpty()) {
                throw new IllegalArgumentException("An empty list was passed as a @DefineList parameter. Can't define an empty attribute.");
            }
            if (argsList.stream().anyMatch(Objects::isNull)) {
                throw new IllegalArgumentException("A @DefineList parameter was passed a list with null values in it.");
            }
            stmt.defineList(name, argsList);
        };
    }
}

