/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.config.internal;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.extension.SimpleExtensionConfigurer;
import org.jdbi.v3.core.internal.JdbiClassUtils;
import org.jdbi.v3.core.statement.SqlStatements;
import org.jdbi.v3.core.statement.TemplateEngine;
import org.jdbi.v3.sqlobject.config.UseTemplateEngine;

public class UseTemplateEngineImpl
extends SimpleExtensionConfigurer {
    private static final Class<?>[] TEMPLATE_ENGINE_PARAMETERS = new Class[]{Class.class, Method.class};
    private final TemplateEngine templateEngine;

    public UseTemplateEngineImpl(Annotation annotation, Class<?> sqlObjectType, @Nullable Method method) {
        UseTemplateEngine useTemplateEngine = (UseTemplateEngine)annotation;
        Class<? extends TemplateEngine> engineClass = useTemplateEngine.value();
        this.templateEngine = (TemplateEngine)JdbiClassUtils.findConstructorAndCreateInstance(engineClass, (Class[])TEMPLATE_ENGINE_PARAMETERS, handle -> handle.invokeExact(sqlObjectType, method));
    }

    public void configure(ConfigRegistry config, Annotation annotation, Class<?> sqlObjectType) {
        ((SqlStatements)config.get(SqlStatements.class)).setTemplateEngine(this.templateEngine);
    }
}

