/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.customizer;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import org.jdbi.v3.core.internal.IterableLike;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;
import org.jdbi.v3.sqlobject.internal.ParameterUtil;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
@SqlStatementCustomizingAnnotation(value=Factory.class)
public @interface BindList {
    public String value() default "";

    public EmptyHandling onEmpty() default EmptyHandling.THROW;

    public static enum EmptyHandling {
        VOID,
        NULL,
        THROW;

        static final String valueNotHandledMessage = "EmptyHandling type on BindList not handled. Please report this to the jdbi developers.";
    }

    public static final class Factory
    implements SqlStatementCustomizerFactory {
        @Override
        public SqlStatementParameterCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Type type) {
            BindList bindList = (BindList)annotation;
            String name = ParameterUtil.getParameterName(bindList, bindList.value(), param);
            return (stmt, arg) -> {
                if (arg == null || IterableLike.isEmpty((Object)arg)) {
                    switch (bindList.onEmpty()) {
                        case VOID: {
                            stmt.define(name, (Object)"");
                            return;
                        }
                        case NULL: {
                            stmt.define(name, (Object)"null");
                            return;
                        }
                        case THROW: {
                            throw new IllegalArgumentException(arg == null ? "argument is null; null was explicitly forbidden on this instance of BindList" : "argument is empty; emptiness was explicitly forbidden on this instance of BindList");
                        }
                    }
                    throw new IllegalStateException("EmptyHandling type on BindList not handled. Please report this to the jdbi developers.");
                }
                stmt.bindList(name, IterableLike.toList((Object)arg));
            };
        }
    }
}

