/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.customizer;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.jdbi.v3.sqlobject.customizer.BindListUtil;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizer;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.internal.ParameterUtil;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
@SqlStatementCustomizingAnnotation(value=Factory.class)
public @interface BindBeanList {
    public String value() default "";

    public String[] propertyNames();

    public static final class Factory
    implements SqlStatementCustomizerFactory {
        @Override
        public SqlStatementCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Object arg) {
            BindBeanList bindBeanList = (BindBeanList)annotation;
            String name = ParameterUtil.getParameterName(bindBeanList, bindBeanList.value(), param);
            if (arg == null) {
                throw new IllegalArgumentException("argument is null; null was explicitly forbidden on BindBeanList");
            }
            ArrayList list = new ArrayList();
            Iterator<?> iter = BindListUtil.toIterator(arg);
            while (iter.hasNext()) {
                list.add(iter.next());
            }
            return stmt -> stmt.bindBeanList(name, list, Arrays.asList(bindBeanList.propertyNames()));
        }
    }
}

