/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.statement;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.function.Function;
import org.jdbi.v3.core.extension.HandleSupplier;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.result.ResultSetIterable;
import org.jdbi.v3.core.statement.SqlStatement;
import org.jdbi.v3.core.statement.Update;
import org.jdbi.v3.sqlobject.Handler;
import org.jdbi.v3.sqlobject.HandlerFactory;
import org.jdbi.v3.sqlobject.SqlMethodAnnotation;
import org.jdbi.v3.sqlobject.SqlObjects;
import org.jdbi.v3.sqlobject.UnableToCreateSqlObjectException;
import org.jdbi.v3.sqlobject.statement.CustomizingStatementHandler;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.ResultReturner;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@SqlMethodAnnotation(value=Factory.class)
public @interface SqlUpdate {
    public String value() default "";

    public static class UpdateHandler
    extends CustomizingStatementHandler {
        private final Class<?> sqlObjectType;
        private final Function<Update, Object> returner;

        UpdateHandler(Class<?> sqlObjectType, Method method) {
            super(sqlObjectType, method);
            this.sqlObjectType = sqlObjectType;
            boolean isGetGeneratedKeys = method.isAnnotationPresent(GetGeneratedKeys.class);
            Type returnType = GenericTypes.resolveType((Type)method.getGenericReturnType(), sqlObjectType);
            if (isGetGeneratedKeys) {
                ResultReturner magic = ResultReturner.forMethod(sqlObjectType, method);
                GetGeneratedKeys ggk = method.getAnnotation(GetGeneratedKeys.class);
                RowMapper<?> mapper = ResultReturner.rowMapperFor(ggk, returnType);
                this.returner = update -> {
                    String columnName = ggk.columnName();
                    ResultSetIterable resultSetIterable = columnName.isEmpty() ? update.executeAndReturnGeneratedKeys(new String[0]) : update.executeAndReturnGeneratedKeys(new String[]{columnName});
                    return magic.result(resultSetIterable.map(mapper), update.getContext());
                };
            } else if (this.isNumeric(method.getReturnType())) {
                this.returner = update -> update.execute();
            } else if (this.isBoolean(method.getReturnType())) {
                this.returner = update -> update.execute() > 0;
            } else {
                throw new UnableToCreateSqlObjectException(this.invalidReturnTypeMessage(method, returnType));
            }
        }

        @Override
        public Object invoke(Object target, Object[] args, HandleSupplier handle) {
            String sql = ((SqlObjects)handle.getConfig(SqlObjects.class)).getSqlLocator().locate(this.sqlObjectType, this.getMethod());
            Update update = handle.getHandle().createUpdate(sql);
            this.applyCustomizers((SqlStatement<?>)update, args);
            return this.returner.apply(update);
        }

        private boolean isNumeric(Class<?> type) {
            return Number.class.isAssignableFrom(type) || type.equals(Integer.TYPE) || type.equals(Long.TYPE) || type.equals(Void.TYPE);
        }

        private boolean isBoolean(Class<?> type) {
            return type.equals(Boolean.TYPE) || type.equals(Boolean.class);
        }

        private String invalidReturnTypeMessage(Method method, Type returnType) {
            return method.getDeclaringClass().getSimpleName() + "." + method.getName() + " method is annotated with @SqlUpdate so should return void, boolean, or Number but is returning: " + returnType;
        }
    }

    public static class Factory
    implements HandlerFactory {
        @Override
        public Handler buildHandler(Class<?> sqlObjectType, Method method) {
            return new UpdateHandler(sqlObjectType, method);
        }
    }
}

