/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.statement;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.extension.HandleSupplier;
import org.jdbi.v3.core.internal.ReflectionArrayIterator;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.result.ResultIterable;
import org.jdbi.v3.core.result.ResultIterator;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.SqlStatement;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;
import org.jdbi.v3.sqlobject.Handler;
import org.jdbi.v3.sqlobject.HandlerFactory;
import org.jdbi.v3.sqlobject.SingleValue;
import org.jdbi.v3.sqlobject.SqlMethodAnnotation;
import org.jdbi.v3.sqlobject.SqlObjects;
import org.jdbi.v3.sqlobject.UnableToCreateSqlObjectException;
import org.jdbi.v3.sqlobject.statement.BatchChunkSize;
import org.jdbi.v3.sqlobject.statement.CustomizingStatementHandler;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.ResultReturner;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@SqlMethodAnnotation(value=Factory.class)
public @interface SqlBatch {
    public String value() default "";

    public boolean transactional() default true;

    public static class BatchHandler
    extends CustomizingStatementHandler {
        private final Class<?> sqlObjectType;
        private final SqlBatch sqlBatch;
        private final ChunkSizeFunction batchChunkSize;
        private final Function<PreparedBatch, ResultIterator<?>> batchIntermediate;
        private final ResultReturner magic;

        BatchHandler(Class<?> sqlObjectType, Method method) {
            super(sqlObjectType, method);
            this.sqlObjectType = sqlObjectType;
            this.sqlBatch = method.getAnnotation(SqlBatch.class);
            this.batchChunkSize = this.determineBatchChunkSize(sqlObjectType, method);
            GetGeneratedKeys getGeneratedKeys = method.getAnnotation(GetGeneratedKeys.class);
            if (getGeneratedKeys == null) {
                if (!BatchHandler.returnTypeIsValid(method.getReturnType())) {
                    throw new UnableToCreateSqlObjectException(BatchHandler.invalidReturnTypeMessage(method));
                }
                this.batchIntermediate = PreparedBatch::executeAndGetModCount;
                this.magic = ResultReturner.forOptionalReturn(sqlObjectType, method);
            } else {
                this.magic = ResultReturner.forMethod(sqlObjectType, method);
                Function<StatementContext, RowMapper> mapper = ctx -> ResultReturner.rowMapperFor(getGeneratedKeys, this.magic.elementType((StatementContext)ctx));
                this.batchIntermediate = getGeneratedKeys.columnName().isEmpty() ? batch -> batch.executeAndReturnGeneratedKeys(new String[0]).map((RowMapper)mapper.apply(batch.getContext())).iterator() : batch -> batch.executeAndReturnGeneratedKeys(new String[]{getGeneratedKeys.columnName()}).map((RowMapper)mapper.apply(batch.getContext())).iterator();
            }
        }

        private ChunkSizeFunction determineBatchChunkSize(Class<?> sqlObjectType, Method method) {
            int batchChunkSizeParameterIndex = this.indexOfBatchChunkSizeParameter(method);
            if (batchChunkSizeParameterIndex >= 0) {
                return new ParamBasedChunkSizeFunction(batchChunkSizeParameterIndex);
            }
            if (method.isAnnotationPresent(BatchChunkSize.class)) {
                int size = method.getAnnotation(BatchChunkSize.class).value();
                if (size <= 0) {
                    throw new IllegalArgumentException("Batch chunk size must be >= 0");
                }
                return new ConstantChunkSizeFunction(size);
            }
            if (sqlObjectType.isAnnotationPresent(BatchChunkSize.class)) {
                int size = sqlObjectType.getAnnotation(BatchChunkSize.class).value();
                return new ConstantChunkSizeFunction(size);
            }
            return new ConstantChunkSizeFunction(Integer.MAX_VALUE);
        }

        private int indexOfBatchChunkSizeParameter(Method method) {
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            return IntStream.range(0, parameterAnnotations.length).filter(i -> Stream.of(parameterAnnotations[i]).anyMatch(BatchChunkSize.class::isInstance)).findFirst().orElse(-1);
        }

        @Override
        public Object invoke(Object target, Object[] args, HandleSupplier h) {
            final Handle handle = h.getHandle();
            final String sql = ((SqlObjects)handle.getConfig().get(SqlObjects.class)).getSqlLocator().locate(this.sqlObjectType, this.getMethod());
            final int chunkSize = this.batchChunkSize.call(args);
            final Iterator<Object[]> batchArgs = this.zipArgs(this.getMethod(), args);
            ResultIterator<Object> result = new ResultIterator<Object>(){
                ResultIterator<?> batchResult;
                boolean closed = false;
                {
                    this.hasNext();
                }

                public boolean hasNext() {
                    if (this.closed) {
                        throw new IllegalStateException("closed");
                    }
                    if (this.batchResult != null) {
                        if (this.batchResult.hasNext()) {
                            return true;
                        }
                        this.batchResult.close();
                    }
                    if (!batchArgs.hasNext()) {
                        return false;
                    }
                    PreparedBatch batch = handle.prepareBatch(sql);
                    for (int i = 0; i < chunkSize && batchArgs.hasNext(); ++i) {
                        this.applyCustomizers((SqlStatement<?>)batch, (Object[])batchArgs.next());
                        batch.add();
                    }
                    this.batchResult = this.executeBatch(handle, batch);
                    return this.hasNext();
                }

                public Object next() {
                    if (this.closed) {
                        throw new IllegalStateException("closed");
                    }
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return this.batchResult.next();
                }

                public StatementContext getContext() {
                    return this.batchResult.getContext();
                }

                public void close() {
                    this.closed = true;
                    this.batchResult.close();
                }
            };
            ResultIterable iterable = ResultIterable.of((ResultIterator)result);
            return this.magic.result(iterable, result.getContext());
        }

        private Iterator<Object[]> zipArgs(Method method, Object[] args) {
            boolean foundIterator = false;
            final ArrayList extras = new ArrayList();
            for (int paramIdx = 0; paramIdx < method.getParameterCount(); ++paramIdx) {
                boolean singleValue = method.getParameters()[paramIdx].isAnnotationPresent(SingleValue.class);
                Object arg = args[paramIdx];
                if (!singleValue && ReflectionArrayIterator.isIterable((Object)arg)) {
                    extras.add(ReflectionArrayIterator.of((Object)arg));
                    foundIterator = true;
                    continue;
                }
                extras.add(Stream.generate(() -> arg).iterator());
            }
            if (!foundIterator) {
                throw new UnableToCreateStatementException("@SqlBatch method has no Iterable or array parameters, did you mean @SqlQuery?", null, null);
            }
            final Object[] sharedArg = new Object[args.length];
            return new Iterator<Object[]>(){

                @Override
                public boolean hasNext() {
                    for (Iterator extra : extras) {
                        if (extra.hasNext()) continue;
                        return false;
                    }
                    return true;
                }

                @Override
                public Object[] next() {
                    for (int i = 0; i < extras.size(); ++i) {
                        sharedArg[i] = ((Iterator)extras.get(i)).next();
                    }
                    return sharedArg;
                }
            };
        }

        private ResultIterator<?> executeBatch(Handle handle, PreparedBatch batch) {
            if (!handle.isInTransaction() && this.sqlBatch.transactional()) {
                return (ResultIterator)handle.inTransaction(c -> this.batchIntermediate.apply(batch));
            }
            return this.batchIntermediate.apply(batch);
        }

        private static boolean returnTypeIsValid(Class<?> type) {
            return type.equals(Void.TYPE) || type.isArray() && type.getComponentType().equals(Integer.TYPE);
        }

        private static String invalidReturnTypeMessage(Method method) {
            return method.getDeclaringClass() + "." + method.getName() + " method is annotated with @SqlBatch so should return void or int[] but is returning: " + method.getReturnType();
        }

        private static class ParamBasedChunkSizeFunction
        implements ChunkSizeFunction {
            private final int index;

            ParamBasedChunkSizeFunction(int index) {
                this.index = index;
            }

            @Override
            public int call(Object[] args) {
                return (Integer)args[this.index];
            }
        }

        private static class ConstantChunkSizeFunction
        implements ChunkSizeFunction {
            private final int value;

            ConstantChunkSizeFunction(int value) {
                this.value = value;
            }

            @Override
            public int call(Object[] args) {
                return this.value;
            }
        }

        private static interface ChunkSizeFunction {
            public int call(Object[] var1);
        }
    }

    public static class Factory
    implements HandlerFactory {
        @Override
        public Handler buildHandler(Class<?> sqlObjectType, Method method) {
            return new BatchHandler(sqlObjectType, method);
        }
    }
}

