/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.config;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.ColumnMappers;
import org.jdbi.v3.sqlobject.config.ConfigurerFactory;
import org.jdbi.v3.sqlobject.config.ConfiguringAnnotation;

@ConfiguringAnnotation(value=Factory.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD})
public @interface RegisterColumnMapper {
    public Class<? extends ColumnMapper<?>>[] value();

    public static class Factory
    implements ConfigurerFactory {
        @Override
        public Consumer<ConfigRegistry> createForMethod(Annotation annotation, Class<?> sqlObjectType, Method method) {
            return this.create((RegisterColumnMapper)annotation);
        }

        @Override
        public Consumer<ConfigRegistry> createForType(Annotation annotation, Class<?> sqlObjectType) {
            return this.create((RegisterColumnMapper)annotation);
        }

        private Consumer<ConfigRegistry> create(RegisterColumnMapper ma) {
            ArrayList m = new ArrayList(ma.value().length);
            try {
                Class<? extends ColumnMapper<?>>[] mcs = ma.value();
                for (int i = 0; i < mcs.length; ++i) {
                    m.add(mcs[i].newInstance());
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to create a specified column mapper", e);
            }
            return config -> m.forEach(arg_0 -> ((ColumnMappers)((ColumnMappers)config.get(ColumnMappers.class))).register(arg_0));
        }
    }
}

