/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.config;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.mapper.RowMapperFactory;
import org.jdbi.v3.core.mapper.RowMappers;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.sqlobject.config.ConfigurerFactory;
import org.jdbi.v3.sqlobject.config.ConfiguringAnnotation;

@Retention(value=RetentionPolicy.RUNTIME)
@ConfiguringAnnotation(value=Factory.class)
@Target(value={ElementType.TYPE, ElementType.METHOD})
public @interface RegisterBeanMapper {
    public Class<?>[] value();

    public String[] prefix() default {};

    public static class Factory
    implements ConfigurerFactory {
        @Override
        public Consumer<ConfigRegistry> createForType(Annotation annotation, Class<?> sqlObjectType) {
            return this.create((RegisterBeanMapper)annotation);
        }

        @Override
        public Consumer<ConfigRegistry> createForMethod(Annotation annotation, Class<?> sqlObjectType, Method method) {
            return this.create((RegisterBeanMapper)annotation);
        }

        private Consumer<ConfigRegistry> create(RegisterBeanMapper annotation) {
            Class<?>[] beanClasses = annotation.value();
            String[] prefixes = annotation.prefix();
            ArrayList<RowMapperFactory> mappers = new ArrayList<RowMapperFactory>(beanClasses.length);
            if (prefixes.length == 0) {
                for (Class<?> beanClass : beanClasses) {
                    mappers.add(BeanMapper.of(beanClass));
                }
            } else if (prefixes.length == beanClasses.length) {
                for (int i = 0; i < beanClasses.length; ++i) {
                    mappers.add(BeanMapper.of(beanClasses[i], (String)prefixes[i]));
                }
            } else {
                throw new IllegalStateException("RegisterBeanMapper.prefix() must have the same number of elements as value()");
            }
            return config -> mappers.forEach(arg_0 -> ((RowMappers)((RowMappers)config.get(RowMappers.class))).register(arg_0));
        }
    }
}

