/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jdbi.v3.core.SqlStatement;
import org.jdbi.v3.core.exception.UnableToCreateStatementException;
import org.jdbi.v3.sqlobject.Bind;
import org.jdbi.v3.sqlobject.Handler;
import org.jdbi.v3.sqlobject.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.SqlStatementCustomizingAnnotation;

abstract class CustomizingStatementHandler
implements Handler {
    private final List<FactoryAnnotationPair> typeBasedCustomizerFactories = new ArrayList<FactoryAnnotationPair>();
    private final List<FactoryAnnotationPair> methodBasedCustomizerFactories = new ArrayList<FactoryAnnotationPair>();
    private final List<FactoryAnnotationParameterIndex> paramBasedCustomizerFactories = new ArrayList<FactoryAnnotationParameterIndex>();
    private final Class<?> sqlObjectType;
    private final Method method;

    CustomizingStatementHandler(Class<?> sqlObjectType, Method method) {
        this.sqlObjectType = sqlObjectType;
        this.method = method;
        for (Annotation annotation : sqlObjectType.getAnnotations()) {
            SqlStatementCustomizerFactory f;
            if (!annotation.annotationType().isAnnotationPresent(SqlStatementCustomizingAnnotation.class)) continue;
            SqlStatementCustomizingAnnotation a = annotation.annotationType().getAnnotation(SqlStatementCustomizingAnnotation.class);
            try {
                f = a.value().newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to create sql statement customizer factory", e);
            }
            this.typeBasedCustomizerFactories.add(new FactoryAnnotationPair(f, annotation));
        }
        for (Annotation annotation : method.getAnnotations()) {
            SqlStatementCustomizerFactory f;
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (!annotationType.isAnnotationPresent(SqlStatementCustomizingAnnotation.class)) continue;
            SqlStatementCustomizingAnnotation scf = annotationType.getAnnotation(SqlStatementCustomizingAnnotation.class);
            try {
                f = scf.value().newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to instantiate statement customizer factory", e);
            }
            this.methodBasedCustomizerFactories.add(new FactoryAnnotationPair(f, annotation));
        }
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        Parameter[] parameters = method.getParameters();
        for (int paramIndex = 0; paramIndex < paramAnnotations.length; ++paramIndex) {
            boolean foundCustomizingAnnotations = false;
            for (Annotation annotation : paramAnnotations[paramIndex]) {
                SqlStatementCustomizerFactory f;
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (!annotationType.isAnnotationPresent(SqlStatementCustomizingAnnotation.class)) continue;
                SqlStatementCustomizingAnnotation sca = annotation.annotationType().getAnnotation(SqlStatementCustomizingAnnotation.class);
                try {
                    f = sca.value().newInstance();
                }
                catch (Exception e) {
                    throw new IllegalStateException("unable to instantiate sql statement customizer factory", e);
                }
                this.paramBasedCustomizerFactories.add(new FactoryAnnotationParameterIndex(f, annotation, parameters[paramIndex], paramIndex));
                foundCustomizingAnnotations = true;
            }
            if (foundCustomizingAnnotations) continue;
            this.paramBasedCustomizerFactories.add(new FactoryAnnotationParameterIndex(new Bind.Factory(), null, parameters[paramIndex], paramIndex));
        }
    }

    protected void applyCustomizers(SqlStatement<?> q, Object[] args) {
        for (FactoryAnnotationPair pair : this.typeBasedCustomizerFactories) {
            try {
                pair.factory.createForType(pair.annotation, this.sqlObjectType).apply(q);
            }
            catch (SQLException e) {
                throw new UnableToCreateStatementException("unable to apply customizer", (Throwable)e, q.getContext());
            }
        }
        for (FactoryAnnotationPair pair : this.methodBasedCustomizerFactories) {
            try {
                pair.factory.createForMethod(pair.annotation, this.sqlObjectType, this.method).apply(q);
            }
            catch (SQLException e) {
                throw new UnableToCreateStatementException("unable to apply customizer", (Throwable)e, q.getContext());
            }
        }
        if (args != null) {
            for (FactoryAnnotationParameterIndex param : this.paramBasedCustomizerFactories) {
                try {
                    param.factory.createForParameter(param.annotation, this.sqlObjectType, this.method, param.parameter, param.index, args[param.index]).apply(q);
                }
                catch (SQLException e) {
                    throw new UnableToCreateStatementException("unable to apply customizer", (Throwable)e, q.getContext());
                }
            }
        }
    }

    protected Method getMethod() {
        return this.method;
    }

    private static class FactoryAnnotationParameterIndex {
        private final SqlStatementCustomizerFactory factory;
        private final Annotation annotation;
        private final Parameter parameter;
        private final int index;

        FactoryAnnotationParameterIndex(SqlStatementCustomizerFactory factory, Annotation annotation, Parameter parameter, int index) {
            this.factory = factory;
            this.annotation = annotation;
            this.parameter = parameter;
            this.index = index;
        }
    }

    private static class FactoryAnnotationPair {
        private final SqlStatementCustomizerFactory factory;
        private final Annotation annotation;

        FactoryAnnotationPair(SqlStatementCustomizerFactory factory, Annotation annotation) {
            this.factory = factory;
            this.annotation = annotation;
        }
    }
}

