/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Iterator;
import org.jdbi.v3.core.PreparedBatchPart;
import org.jdbi.v3.core.util.GenericTypes;
import org.jdbi.v3.sqlobject.SingleValue;
import org.jdbi.v3.sqlobject.SqlStatementCustomizer;
import org.jdbi.v3.sqlobject.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.internal.ParameterUtil;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
@SqlStatementCustomizingAnnotation(value=Factory.class)
public @interface Bind {
    public String value() default "";

    public static class Factory
    implements SqlStatementCustomizerFactory {
        @Override
        public SqlStatementCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Object arg) {
            Bind b = (Bind)annotation;
            String nameFromAnnotation = b == null ? "" : b.value();
            String name = ParameterUtil.getParameterName(b, nameFromAnnotation, param);
            return stmt -> {
                Class<?> type = param.getParameterizedType();
                if (stmt instanceof PreparedBatchPart && !param.isAnnotationPresent(SingleValue.class)) {
                    Class erasedType = GenericTypes.getErasedType((Type)type);
                    if (Iterable.class.isAssignableFrom(erasedType)) {
                        type = (Type)GenericTypes.findGenericParameter((Type)type, Iterable.class).get();
                    } else if (Iterator.class.isAssignableFrom(erasedType)) {
                        type = (Type)GenericTypes.findGenericParameter((Type)type, Iterator.class).get();
                    } else if (GenericTypes.isArray((Type)type)) {
                        type = ((Class)type).getComponentType();
                    }
                }
                stmt.bindByType(index, arg, (Type)type);
                stmt.bindByType(name, arg, (Type)type);
            };
        }
    }
}

