/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.jdbi.v3.sqlobject.Binder;
import org.jdbi.v3.sqlobject.BinderFactory;
import org.jdbi.v3.sqlobject.BindingAnnotation;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
@BindingAnnotation(value=Factory.class)
public @interface BindBean {
    public String value() default "";

    public static class Factory
    implements BinderFactory<BindBean, Object> {
        @Override
        public Binder<BindBean, Object> build(BindBean annotation) {
            return (statement, param, index, bind, bean) -> {
                String prefix = bind.value();
                if (prefix.isEmpty()) {
                    statement.bindBean(bean);
                } else {
                    statement.bindBean(prefix, bean);
                }
            };
        }
    }
}

