/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.reflect.Type;
import java.util.Iterator;
import org.jdbi.v3.core.PreparedBatchPart;
import org.jdbi.v3.core.util.GenericTypes;
import org.jdbi.v3.sqlobject.Bind;
import org.jdbi.v3.sqlobject.Binder;
import org.jdbi.v3.sqlobject.BinderFactory;
import org.jdbi.v3.sqlobject.internal.ParameterUtil;

class DefaultObjectBinder
implements BinderFactory<Bind, Object> {
    DefaultObjectBinder() {
    }

    @Override
    public Binder<Bind, Object> build(Bind annotation) {
        return (q, param, index, b, arg) -> {
            String nameFromAnnotation = b == null ? "" : b.value();
            String name = ParameterUtil.getParameterName(b, nameFromAnnotation, param);
            Type type = param.getParameterizedType();
            if (q instanceof PreparedBatchPart) {
                Class erasedType = GenericTypes.getErasedType((Type)type);
                if (Iterable.class.isAssignableFrom(erasedType)) {
                    type = (Type)GenericTypes.findGenericParameter((Type)type, Iterable.class).get();
                } else if (Iterator.class.isAssignableFrom(erasedType)) {
                    type = (Type)GenericTypes.findGenericParameter((Type)type, Iterator.class).get();
                }
            }
            q.bindByType(index, arg, type);
            q.bindByType(name, arg, type);
        };
    }
}

