/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.jdbi.v3.core.HandleSupplier;
import org.jdbi.v3.core.Query;
import org.jdbi.v3.core.ResultBearing;
import org.jdbi.v3.core.ResultIterator;
import org.jdbi.v3.core.StatementContext;
import org.jdbi.v3.core.exception.UnableToCreateStatementException;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.util.GenericTypes;
import org.jdbi.v3.sqlobject.customizers.UseRowMapper;

abstract class ResultReturnThing {
    ResultReturnThing() {
    }

    public Object map(Method method, Query<?> q, HandleSupplier handle) {
        if (method.isAnnotationPresent(UseRowMapper.class)) {
            RowMapper<?> mapper;
            try {
                mapper = method.getAnnotation(UseRowMapper.class).value().newInstance();
            }
            catch (Exception e) {
                throw new UnableToCreateStatementException("unable to access mapper", (Throwable)e, null);
            }
            return this.result((ResultBearing<?>)q.map(mapper), handle);
        }
        return this.result((ResultBearing<?>)q.mapTo(this.elementType(q.getContext())), handle);
    }

    static ResultReturnThing forMethod(Class<?> extensionType, Method method) {
        Type returnType = GenericTypes.resolveType((Type)method.getGenericReturnType(), extensionType);
        Class returnClass = GenericTypes.getErasedType((Type)returnType);
        if (Void.TYPE.equals(returnClass)) {
            throw new IllegalStateException(String.format("Method %s#%s is annotated as if it should return a value, but the method is void.", method.getDeclaringClass().getName(), method.getName()));
        }
        if (ResultBearing.class.isAssignableFrom(returnClass)) {
            return new ResultBearingResultReturnThing(returnType);
        }
        if (Stream.class.isAssignableFrom(returnClass)) {
            return new StreamReturnThing(returnType);
        }
        if (Iterator.class.isAssignableFrom(returnClass)) {
            return new IteratorResultReturnThing(returnType);
        }
        return new DefaultResultReturnThing(method, returnType);
    }

    protected abstract Object result(ResultBearing<?> var1, HandleSupplier var2);

    protected abstract Type elementType(StatementContext var1);

    static class IteratorResultReturnThing
    extends ResultReturnThing {
        private final Type elementType;

        IteratorResultReturnThing(Type returnType) {
            this.elementType = (Type)GenericTypes.findGenericParameter((Type)returnType, Iterator.class).orElseThrow(() -> new IllegalStateException("Cannot reflect Iterator<T> element type T in method return type " + returnType));
        }

        @Override
        protected Object result(ResultBearing<?> q, HandleSupplier handle) {
            boolean isEmpty;
            final ResultIterator itty = q.iterator();
            boolean bl = isEmpty = !itty.hasNext();
            if (isEmpty) {
                itty.close();
            }
            return new ResultIterator<Object>(){
                private boolean closed;
                private boolean hasNext;
                {
                    this.closed = isEmpty;
                    this.hasNext = !isEmpty;
                }

                public void close() {
                    if (!this.closed) {
                        this.closed = true;
                        itty.close();
                    }
                }

                public boolean hasNext() {
                    return this.hasNext;
                }

                public Object next() {
                    Object rs;
                    try {
                        rs = itty.next();
                        this.hasNext = itty.hasNext();
                    }
                    catch (RuntimeException e) {
                        this.closeIgnoreException();
                        throw e;
                    }
                    if (!this.hasNext) {
                        this.close();
                    }
                    return rs;
                }

                public void closeIgnoreException() {
                    try {
                        this.close();
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }

                public void remove() {
                    itty.remove();
                }
            };
        }

        @Override
        protected Type elementType(StatementContext ctx) {
            return this.elementType;
        }
    }

    static class ResultBearingResultReturnThing
    extends ResultReturnThing {
        private final Type elementType;

        ResultBearingResultReturnThing(Type returnType) {
            this.elementType = (Type)GenericTypes.findGenericParameter((Type)returnType, Query.class).orElseThrow(() -> new IllegalStateException("Cannot reflect Query<T> element type T in method return type " + returnType));
        }

        @Override
        protected Object result(ResultBearing<?> q, HandleSupplier handle) {
            return q;
        }

        @Override
        protected Type elementType(StatementContext ctx) {
            return this.elementType;
        }
    }

    static class DefaultResultReturnThing
    extends ResultReturnThing {
        private final Type returnType;

        DefaultResultReturnThing(Method method, Type returnType) {
            this.returnType = returnType;
        }

        @Override
        protected Object result(ResultBearing<?> q, HandleSupplier handle) {
            Collector collector;
            if (q instanceof Query && (collector = (Collector)((Query)q).getContext().findCollectorFor(this.returnType).orElse(null)) != null) {
                return q.collect(collector);
            }
            return q.findFirst().orElse(null);
        }

        @Override
        protected Type elementType(StatementContext ctx) {
            return ctx.elementTypeFor(this.returnType).orElse(this.returnType);
        }
    }

    static class StreamReturnThing
    extends ResultReturnThing {
        private final Type elementType;

        StreamReturnThing(Type returnType) {
            this.elementType = (Type)GenericTypes.findGenericParameter((Type)returnType, Stream.class).orElseThrow(() -> new IllegalStateException("Cannot reflect Stream<T> element type T in method return type " + returnType));
        }

        @Override
        protected Object result(ResultBearing<?> q, HandleSupplier handle) {
            return q.stream();
        }

        @Override
        protected Type elementType(StatementContext ctx) {
            return this.elementType;
        }
    }
}

