/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import org.jdbi.v3.core.transaction.TransactionIsolationLevel;
import org.jdbi.v3.sqlobject.Handler;
import org.jdbi.v3.sqlobject.HandlerDecorator;
import org.jdbi.v3.sqlobject.SqlMethodDecoratingAnnotation;
import org.jdbi.v3.sqlobject.TransactionDecorator;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@SqlMethodDecoratingAnnotation(value=Decorator.class)
public @interface Transaction {
    public TransactionIsolationLevel value() default TransactionIsolationLevel.INVALID_LEVEL;

    public static class Decorator
    implements HandlerDecorator {
        @Override
        public Handler decorateHandler(Handler handler, Class<?> sqlObjectType, Method method) {
            return new TransactionDecorator(handler, method.getAnnotation(Transaction.class));
        }
    }
}

