/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.unstable;

import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jdbi.v3.sqlobject.Binder;
import org.jdbi.v3.sqlobject.BinderFactory;
import org.jdbi.v3.sqlobject.BindingAnnotation;
import org.jdbi.v3.sqlobject.SqlStatementCustomizer;
import org.jdbi.v3.sqlobject.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.util.GenericTypes;

@Retention(value=RetentionPolicy.RUNTIME)
@SqlStatementCustomizingAnnotation(value=CustomizerFactory.class)
@BindingAnnotation(value=BindingFactory.class)
public @interface BindIn {
    public String value();

    public static class BindingFactory
    implements BinderFactory<BindIn, Object> {
        @Override
        public Binder<BindIn, Object> build(BindIn in) {
            String key = in.value();
            return (q, param, index, bind, arg) -> {
                Iterable coll = (Iterable)arg;
                Type parameterType = param.getParameterizedType();
                Type elementType = (Type)((Object)GenericTypes.findGenericParameter((Type)parameterType, Iterable.class).orElse(Object.class));
                int idx = 0;
                for (Object s : coll) {
                    q.bindByType("__" + key + "_" + idx++, s, elementType);
                }
            };
        }
    }

    public static class CustomizerFactory
    implements SqlStatementCustomizerFactory {
        @Override
        public SqlStatementCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Object arg) {
            Collection coll = (Collection)arg;
            BindIn in = (BindIn)annotation;
            String key = in.value();
            ArrayList<String> ids = new ArrayList<String>();
            for (int idx = 0; idx < coll.size(); ++idx) {
                ids.add("__" + key + "_" + idx);
            }
            StringBuilder names = new StringBuilder();
            Iterator i = ids.iterator();
            while (i.hasNext()) {
                names.append(":").append((String)i.next());
                if (!i.hasNext()) continue;
                names.append(",");
            }
            String ns = names.toString();
            return q -> q.define(key, (Object)ns);
        }
    }
}

