/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.customizers;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.jdbi.v3.SqlStatement;
import org.jdbi.v3.argument.ArgumentFactory;
import org.jdbi.v3.sqlobject.SqlStatementCustomizer;
import org.jdbi.v3.sqlobject.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.SqlStatementCustomizingAnnotation;

@SqlStatementCustomizingAnnotation(value=Factory.class)
@Target(value={ElementType.TYPE, ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface RegisterArgumentFactory {
    public Class<? extends ArgumentFactory>[] value();

    public static class Factory
    implements SqlStatementCustomizerFactory {
        @Override
        public SqlStatementCustomizer createForType(Annotation annotation, Class<?> sqlObjectType) {
            return this.create(annotation);
        }

        @Override
        public SqlStatementCustomizer createForMethod(Annotation annotation, Class<?> sqlObjectType, Method method) {
            return this.create(annotation);
        }

        private SqlStatementCustomizer create(Annotation annotation) {
            RegisterArgumentFactory raf = (RegisterArgumentFactory)annotation;
            ArrayList<ArgumentFactory> ary = new ArrayList<ArgumentFactory>(raf.value().length);
            for (Class<? extends ArgumentFactory> aClass : raf.value()) {
                try {
                    ary.add(aClass.newInstance());
                }
                catch (Exception e) {
                    throw new IllegalStateException("unable to instantiate specified argument factory", e);
                }
            }
            return q -> ary.forEach(arg_0 -> ((SqlStatement)q).registerArgumentFactory(arg_0));
        }
    }
}

