/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import org.jdbi.v3.Handle;
import org.jdbi.v3.extension.ExtensionFactory;
import org.jdbi.v3.sqlobject.EqualsHandler;
import org.jdbi.v3.sqlobject.FinalizeHandler;
import org.jdbi.v3.sqlobject.GetHandleHelper;
import org.jdbi.v3.sqlobject.Handler;
import org.jdbi.v3.sqlobject.HandlerFactory;
import org.jdbi.v3.sqlobject.HashCodeHandler;
import org.jdbi.v3.sqlobject.PassThroughHandler;
import org.jdbi.v3.sqlobject.SqlMethodAnnotation;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.ToStringHandler;
import org.jdbi.v3.sqlobject.TransactionalHelper;
import org.jdbi.v3.sqlobject.mixins.GetHandle;
import org.jdbi.v3.sqlobject.mixins.Transactional;

public enum SqlObjectFactory implements ExtensionFactory<SqlObject>
{
    INSTANCE;

    private static final MethodInterceptor NO_OP;
    private final Map<Method, Handler> mixinHandlers = new HashMap<Method, Handler>();
    private final ConcurrentMap<Class<?>, Map<Method, Handler>> handlersCache = new ConcurrentHashMap();
    private final ConcurrentMap<Class<?>, Factory> factories = new ConcurrentHashMap();

    private SqlObjectFactory() {
        this.mixinHandlers.putAll(TransactionalHelper.handlers());
        this.mixinHandlers.putAll(GetHandleHelper.handlers());
    }

    public SqlObject createConfig() {
        return new SqlObject();
    }

    public boolean accepts(Class<?> extensionType) {
        if (GetHandle.class.isAssignableFrom(extensionType) || Transactional.class.isAssignableFrom(extensionType)) {
            return true;
        }
        return Stream.of(extensionType.getMethods()).flatMap(m -> Stream.of(m.getAnnotations())).anyMatch(a -> a.annotationType().isAnnotationPresent(SqlMethodAnnotation.class));
    }

    public <E> E attach(Class<E> extensionType, SqlObject config, Supplier<Handle> handle) {
        Factory f = this.factories.computeIfAbsent(extensionType, type -> {
            Enhancer e = new Enhancer();
            e.setClassLoader(extensionType.getClassLoader());
            ArrayList<Class> interfaces = new ArrayList<Class>();
            if (extensionType.isInterface()) {
                interfaces.add(extensionType);
            } else {
                e.setSuperclass(extensionType);
            }
            e.setInterfaces(interfaces.toArray(new Class[interfaces.size()]));
            e.setCallback((Callback)NO_OP);
            return (Factory)e.create();
        });
        Map<Method, Handler> handlers = this.buildHandlersFor(extensionType, config);
        MethodInterceptor interceptor = this.createMethodInterceptor(handlers, handle);
        return extensionType.cast(f.newInstance((Callback)interceptor));
    }

    private Map<Method, Handler> buildHandlersFor(Class<?> sqlObjectType, SqlObject config) {
        return this.handlersCache.computeIfAbsent(sqlObjectType, type -> {
            HashMap<Method, Handler> handlers = new HashMap<Method, Handler>();
            for (Method method : sqlObjectType.getMethods()) {
                Optional<Class> factoryClass = Stream.of(method.getAnnotations()).map(a -> a.annotationType().getAnnotation(SqlMethodAnnotation.class)).filter(Objects::nonNull).map(a -> a.value()).findFirst();
                if (factoryClass.isPresent()) {
                    HandlerFactory factory = this.buildFactory(factoryClass.get());
                    Handler handler = factory.buildHandler(sqlObjectType, method, config);
                    handlers.put(method, handler);
                    continue;
                }
                if (this.mixinHandlers.containsKey(method)) {
                    handlers.put(method, this.mixinHandlers.get(method));
                    continue;
                }
                handlers.put(method, new PassThroughHandler());
            }
            handlers.putAll(EqualsHandler.handler());
            handlers.putAll(ToStringHandler.handler(sqlObjectType.getName()));
            handlers.putAll(HashCodeHandler.handler());
            handlers.putAll(FinalizeHandler.handlerFor(sqlObjectType));
            return handlers;
        });
    }

    private HandlerFactory buildFactory(Class<? extends HandlerFactory> factoryClazz) {
        HandlerFactory factory;
        try {
            factory = factoryClazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Factory class " + factoryClazz + "cannot be instantiated", e);
        }
        return factory;
    }

    private MethodInterceptor createMethodInterceptor(Map<Method, Handler> handlers, Supplier<Handle> handle) {
        return (proxy, method, args, methodProxy) -> {
            Handler handler = (Handler)handlers.get(method);
            if (handler == null) {
                return methodProxy.invokeSuper(proxy, args);
            }
            return handler.invoke(handle, proxy, args, method);
        };
    }

    static {
        NO_OP = (proxy, method, args, methodProxy) -> null;
    }
}

