/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.function.Supplier;
import org.jdbi.v3.Call;
import org.jdbi.v3.Handle;
import org.jdbi.v3.OutParameters;
import org.jdbi.v3.SqlStatement;
import org.jdbi.v3.sqlobject.CustomizingStatementHandler;
import org.jdbi.v3.sqlobject.SqlAnnotations;
import org.jdbi.v3.sqlobject.SqlCall;
import org.jdbi.v3.util.GenericTypes;

class CallHandler
extends CustomizingStatementHandler {
    private final String sql;
    private final boolean returnOutParams;

    CallHandler(Class<?> sqlObjectType, Method method) {
        super(sqlObjectType, method);
        Type returnType = GenericTypes.resolveType((Type)method.getGenericReturnType(), sqlObjectType);
        Class returnClass = GenericTypes.getErasedType((Type)returnType);
        if (Void.TYPE.equals(returnClass)) {
            this.returnOutParams = false;
        } else if (OutParameters.class.isAssignableFrom(returnClass)) {
            this.returnOutParams = true;
        } else {
            throw new IllegalArgumentException("@SqlCall methods may only return null or OutParameters at present");
        }
        this.sql = SqlAnnotations.getSql(method.getAnnotation(SqlCall.class), method);
    }

    @Override
    public Object invoke(Supplier<Handle> handle, Object target, Object[] args, Method method) {
        Call call = handle.get().createCall(this.sql);
        this.populateSqlObjectData(call.getContext());
        this.applyCustomizers((SqlStatement<?>)call, args);
        this.applyBinders((SqlStatement<?>)call, args);
        OutParameters ou = call.invoke();
        if (this.returnOutParams) {
            return ou;
        }
        return null;
    }
}

