/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jdbi.v3.Handle;
import org.jdbi.v3.PreparedBatch;
import org.jdbi.v3.PreparedBatchPart;
import org.jdbi.v3.SqlStatement;
import org.jdbi.v3.exception.UnableToCreateStatementException;
import org.jdbi.v3.sqlobject.CustomizingStatementHandler;
import org.jdbi.v3.sqlobject.SqlAnnotations;
import org.jdbi.v3.sqlobject.SqlBatch;
import org.jdbi.v3.sqlobject.customizers.BatchChunkSize;
import org.jdbi.v3.sqlobject.exceptions.UnableToCreateSqlObjectException;

class BatchHandler
extends CustomizingStatementHandler {
    private final String sql;
    private final boolean transactional;
    private final ChunkSizeFunction batchChunkSize;

    BatchHandler(Class<?> sqlObjectType, Method method) {
        super(sqlObjectType, method);
        if (!BatchHandler.returnTypeIsValid(method.getReturnType())) {
            throw new UnableToCreateSqlObjectException(BatchHandler.invalidReturnTypeMessage(method));
        }
        SqlBatch anno = method.getAnnotation(SqlBatch.class);
        this.sql = SqlAnnotations.getSql(anno, method);
        this.transactional = anno.transactional();
        this.batchChunkSize = this.determineBatchChunkSize(sqlObjectType, method);
    }

    private ChunkSizeFunction determineBatchChunkSize(Class<?> sqlObjectType, Method method) {
        int batchChunkSizeParameterIndex = this.indexOfBatchChunkSizeParameter(method);
        if (batchChunkSizeParameterIndex >= 0) {
            return new ParamBasedChunkSizeFunction(batchChunkSizeParameterIndex);
        }
        if (method.isAnnotationPresent(BatchChunkSize.class)) {
            int size = method.getAnnotation(BatchChunkSize.class).value();
            if (size <= 0) {
                throw new IllegalArgumentException("Batch chunk size must be >= 0");
            }
            return new ConstantChunkSizeFunction(size);
        }
        if (sqlObjectType.isAnnotationPresent(BatchChunkSize.class)) {
            int size = sqlObjectType.getAnnotation(BatchChunkSize.class).value();
            return new ConstantChunkSizeFunction(size);
        }
        return new ConstantChunkSizeFunction(Integer.MAX_VALUE);
    }

    private int indexOfBatchChunkSizeParameter(Method method) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        return IntStream.range(0, parameterAnnotations.length).filter(i -> Stream.of(parameterAnnotations[i]).anyMatch(BatchChunkSize.class::isInstance)).findFirst().orElse(-1);
    }

    @Override
    public Object invoke(Supplier<Handle> h, Object target, Object[] args, Method method) {
        Object[] _args;
        boolean foundIterator = false;
        Handle handle = h.get();
        ArrayList extras = new ArrayList();
        for (Object arg : args) {
            if (arg instanceof Iterable) {
                extras.add(((Iterable)arg).iterator());
                foundIterator = true;
                continue;
            }
            if (arg instanceof Iterator) {
                extras.add((Iterator)arg);
                foundIterator = true;
                continue;
            }
            if (arg.getClass().isArray()) {
                extras.add(Arrays.asList((Object[])arg).iterator());
                foundIterator = true;
                continue;
            }
            extras.add(Stream.generate(() -> arg).iterator());
        }
        if (!foundIterator) {
            throw new UnableToCreateStatementException("@SqlBatch method has no Iterable or array parameters, did you mean @SqlQuery?", null, null);
        }
        int processed = 0;
        ArrayList<int[]> rs_parts = new ArrayList<int[]>();
        PreparedBatch batch = handle.prepareBatch(this.sql);
        this.populateSqlObjectData(batch.getContext());
        this.applyCustomizers((SqlStatement<?>)batch, args);
        int chunk_size = this.batchChunkSize.call(args);
        while ((_args = BatchHandler.next(extras)) != null) {
            PreparedBatchPart part = batch.add();
            this.applyBinders((SqlStatement<?>)part, _args);
            if (++processed != chunk_size) continue;
            processed = 0;
            rs_parts.add(this.executeBatch(handle, batch));
            batch = handle.prepareBatch(this.sql);
            this.populateSqlObjectData(batch.getContext());
            this.applyCustomizers((SqlStatement<?>)batch, args);
        }
        rs_parts.add(this.executeBatch(handle, batch));
        int end_size = 0;
        for (int[] rs_part : rs_parts) {
            end_size += rs_part.length;
        }
        int[] rs = new int[end_size];
        int offset = 0;
        for (int[] rs_part : rs_parts) {
            System.arraycopy(rs_part, 0, rs, offset, rs_part.length);
            offset += rs_part.length;
        }
        return rs;
    }

    private int[] executeBatch(Handle handle, PreparedBatch batch) {
        if (!handle.isInTransaction() && this.transactional) {
            return (int[])handle.inTransaction((conn, status) -> batch.execute());
        }
        return batch.execute();
    }

    private static Object[] next(List<Iterator<?>> args) {
        ArrayList rs = new ArrayList();
        for (Iterator<?> arg : args) {
            if (arg.hasNext()) {
                rs.add(arg.next());
                continue;
            }
            return null;
        }
        return rs.toArray();
    }

    private static boolean returnTypeIsValid(Class<?> type) {
        return type.equals(Void.TYPE) || type.isArray() && type.getComponentType().equals(Integer.TYPE);
    }

    private static String invalidReturnTypeMessage(Method method) {
        return method.getDeclaringClass() + "." + method.getName() + " method is annotated with @SqlBatch so should return void or int[] but is returning: " + method.getReturnType();
    }

    private static class ParamBasedChunkSizeFunction
    implements ChunkSizeFunction {
        private final int index;

        ParamBasedChunkSizeFunction(int index) {
            this.index = index;
        }

        @Override
        public int call(Object[] args) {
            return (Integer)args[this.index];
        }
    }

    private static class ConstantChunkSizeFunction
    implements ChunkSizeFunction {
        private final int value;

        ConstantChunkSizeFunction(int value) {
            this.value = value;
        }

        @Override
        public int call(Object[] args) {
            return this.value;
        }
    }

    private static interface ChunkSizeFunction {
        public int call(Object[] var1);
    }
}

