/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.postgres.internal;

import java.lang.reflect.Type;
import java.util.EnumSet;
import java.util.Optional;
import java.util.function.Function;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.postgres.internal.BitStringEnumSetArgument;

public class BitStringEnumSetArgumentFactory
implements ArgumentFactory.Preparable {
    public Optional<Function<Object, Argument>> prepare(Type type, ConfigRegistry config) {
        if (!EnumSet.class.isAssignableFrom(GenericTypes.getErasedType((Type)type))) {
            return Optional.empty();
        }
        return Optional.of(BitStringEnumSetArgumentFactory.buildGeneric(type));
    }

    private static <E extends Enum<E>> Function<Object, Argument> buildGeneric(Type type) {
        Class enumType = GenericTypes.findGenericParameter((Type)type, EnumSet.class).map(t -> (Class)t).orElseThrow(() -> new IllegalArgumentException("No generic type information for " + String.valueOf(type)));
        return value -> new BitStringEnumSetArgument(enumType, (EnumSet)value);
    }
}

