/*
 * Decompiled with CFR 0.152.
 */
package org.jdbcdslog;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jdbcdslog.JdbcDsLogRuntimeException;
import org.jdbcdslog.LogUtils;
import org.jdbcdslog.Loggers;
import org.jdbcdslog.ProxyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverLoggingProxy
implements Driver {
    static Logger logger = LoggerFactory.getLogger(DriverLoggingProxy.class);
    static final String urlPrefix = "jdbc:jdbcdslog:";
    static final String targetDriverParameter = "targetDriver";

    public boolean acceptsURL(String url) throws SQLException {
        return url != null && url.regionMatches(true, 0, urlPrefix, 0, urlPrefix.length());
    }

    public Connection connect(String url, Properties info) throws SQLException {
        if (Loggers.connectionLogger.isInfoEnabled()) {
            String message = LogUtils.appendStackTrace("connect to URL {} with properties: {}");
            Loggers.connectionLogger.info(message, (Object)url, (Object)info);
        }
        if (!this.acceptsURL(url)) {
            throw new SQLException("Invalid URL" + url);
        }
        url = "jdbc:" + url.substring(urlPrefix.length());
        StringTokenizer ts = new StringTokenizer(url, ":/;=&?", false);
        String targetDriver = null;
        while (ts.hasMoreTokens()) {
            String s = ts.nextToken();
            logger.debug("s = " + s);
            if (!targetDriverParameter.equals(s) || !ts.hasMoreTokens()) continue;
            targetDriver = ts.nextToken();
            break;
        }
        if (targetDriver == null) {
            throw new SQLException("Can't find targetDriver parameter in URL: " + url);
        }
        url = url.substring(0, url.length() - targetDriver.length() - targetDriverParameter.length() - 2);
        try {
            Class.forName(targetDriver);
            return ProxyUtils.wrapByConnectionProxy(DriverManager.getConnection(url, info));
        }
        catch (Exception e) {
            Loggers.connectionLogger.error("Error in getting connection for targetDriver {}, for url {} with properties: {}", new Object[]{targetDriver, url, info, e});
            throw new SQLException(e.getMessage());
        }
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 8;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties properties) throws SQLException {
        String[] as = new String[]{"true", "false"};
        DriverPropertyInfo[] adriverpropertyinfo = new DriverPropertyInfo[6];
        DriverPropertyInfo driverpropertyinfo = new DriverPropertyInfo("user", null);
        driverpropertyinfo.value = properties.getProperty("user");
        driverpropertyinfo.required = true;
        adriverpropertyinfo[0] = driverpropertyinfo;
        driverpropertyinfo = new DriverPropertyInfo("password", null);
        driverpropertyinfo.value = properties.getProperty("password");
        driverpropertyinfo.required = true;
        adriverpropertyinfo[1] = driverpropertyinfo;
        driverpropertyinfo = new DriverPropertyInfo("get_column_name", null);
        driverpropertyinfo.value = properties.getProperty("get_column_name", "true");
        driverpropertyinfo.required = false;
        driverpropertyinfo.choices = as;
        adriverpropertyinfo[2] = driverpropertyinfo;
        driverpropertyinfo = new DriverPropertyInfo("ifexists", null);
        driverpropertyinfo.value = properties.getProperty("ifexists");
        driverpropertyinfo.required = false;
        driverpropertyinfo.choices = as;
        adriverpropertyinfo[3] = driverpropertyinfo;
        driverpropertyinfo = new DriverPropertyInfo("default_schema", null);
        driverpropertyinfo.value = properties.getProperty("default_schema");
        driverpropertyinfo.required = false;
        driverpropertyinfo.choices = as;
        adriverpropertyinfo[4] = driverpropertyinfo;
        driverpropertyinfo = new DriverPropertyInfo("shutdown", null);
        driverpropertyinfo.value = properties.getProperty("shutdown");
        driverpropertyinfo.required = false;
        driverpropertyinfo.choices = as;
        adriverpropertyinfo[5] = driverpropertyinfo;
        return adriverpropertyinfo;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    static {
        try {
            DriverManager.registerDriver(new DriverLoggingProxy());
        }
        catch (Exception exception) {
            Loggers.connectionLogger.error("Error in registering driver", (Throwable)exception);
        }
    }
}

