/*
 * Decompiled with CFR 0.152.
 */
package org.jdbcdslog;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import org.jdbcdslog.LogUtils;
import org.jdbcdslog.Loggers;
import org.jdbcdslog.LoggingHandlerSupport;
import org.jdbcdslog.ProxyUtils;

public class ConnectionSourceLoggingHandler
extends LoggingHandlerSupport {
    public ConnectionSourceLoggingHandler(Object target) {
        super(target);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Object r = method.invoke(this.target, args);
            if (r instanceof Connection) {
                DatabaseMetaData connMetaData = ((Connection)r).getMetaData();
                if (Loggers.connectionLogger.isInfoEnabled()) {
                    String message = LogUtils.appendStackTrace("connect to URL {} for user {}");
                    Loggers.connectionLogger.info(message, (Object)connMetaData.getURL(), (Object)connMetaData.getUserName());
                }
            }
            return ProxyUtils.wrap(r, new Object[0]);
        }
        catch (Throwable t) {
            LogUtils.handleException(t, Loggers.connectionLogger, LogUtils.createLogEntry(method, null, null, null));
            return null;
        }
    }
}

