/*
 * Decompiled with CFR 0.152.
 */
package org.jdbcdslog;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jdbcdslog.MySqlRdbmsSpecifics;
import org.jdbcdslog.OracleRdbmsSpecifics;
import org.jdbcdslog.RdbmsSpecifics;
import org.jdbcdslog.SqlServerRdbmsSpecifics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationParameters {
    private static Logger logger = LoggerFactory.getLogger(ConfigurationParameters.class);
    private static Properties props;
    static long slowQueryThreshold;
    static Boolean showTime;
    static boolean printStackTrace;
    static boolean printFullStackTrace;
    static String printStackTracePattern;
    static boolean inlineQueryParams;
    static RdbmsSpecifics rdbmsSpecifics;
    static boolean logBeforeStatement;
    static boolean logDetailAfterStatement;
    static boolean logAddBatchDetail;
    static boolean logExecuteBatchDetail;

    private static void initSlowQueryThreshold() {
        String sSlowQueryThreshold = props.getProperty("jdbcdslog.slowQueryThreshold");
        if (sSlowQueryThreshold != null && ConfigurationParameters.isLong(sSlowQueryThreshold)) {
            slowQueryThreshold = Long.parseLong(sSlowQueryThreshold);
        }
        if (slowQueryThreshold == -1L) {
            slowQueryThreshold = Long.MAX_VALUE;
        }
    }

    private static void initPrintStackTrace() {
        printStackTrace = "true".equalsIgnoreCase(props.getProperty("jdbcdslog.printStackTrace", "false"));
    }

    private static void initPrintFullStackTrace() {
        printFullStackTrace = "true".equalsIgnoreCase(props.getProperty("jdbcdslog.printFullStackTrace", "false"));
    }

    private static void initPrintStackTracePattern() {
        printStackTracePattern = props.getProperty("jdbcdslog.printStackTracePattern", "");
    }

    private static void initShowTime() {
        showTime = "true".equalsIgnoreCase(props.getProperty("jdbcdslog.showTime", "false"));
    }

    private static void initInlineQueryParams() {
        inlineQueryParams = "true".equalsIgnoreCase(props.getProperty("jdbcdslog.inlineQueryParams", "true"));
    }

    private static void initRdbmsSpecifics() {
        String driverName = props.getProperty("jdbcdslog.driverName");
        if (!"oracle".equalsIgnoreCase(driverName)) {
            if ("mysql".equalsIgnoreCase(driverName)) {
                rdbmsSpecifics = new MySqlRdbmsSpecifics();
            } else if ("sqlserver".equalsIgnoreCase(driverName)) {
                rdbmsSpecifics = new SqlServerRdbmsSpecifics();
            }
        }
    }

    private static void initLogBeforeStatement() {
        logBeforeStatement = "true".equalsIgnoreCase(props.getProperty("jdbcdslog.logBeforeStatement", "false"));
    }

    private static void initLogDetailAfterStatement() {
        logDetailAfterStatement = !logBeforeStatement ? true : "true".equalsIgnoreCase(props.getProperty("jdbcdslog.logDetailAfterStatement", "true"));
    }

    private static void initLogAddBatchDetail() {
        logAddBatchDetail = "true".equalsIgnoreCase(props.getProperty("jdbcdslog.logAddBatchDetail", "true"));
    }

    private static void initLogExecuteBatchDetail() {
        logExecuteBatchDetail = "true".equalsIgnoreCase(props.getProperty("jdbcdslog.logExecuteBatchDetail", "false"));
    }

    private static boolean isLong(String sSlowQueryThreshold) {
        try {
            Long.parseLong(sSlowQueryThreshold);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        slowQueryThreshold = Long.MAX_VALUE;
        showTime = false;
        printStackTrace = false;
        printFullStackTrace = false;
        printStackTracePattern = null;
        inlineQueryParams = true;
        rdbmsSpecifics = new OracleRdbmsSpecifics();
        logBeforeStatement = false;
        logDetailAfterStatement = true;
        logAddBatchDetail = true;
        logExecuteBatchDetail = true;
        ClassLoader loader = ConfigurationParameters.class.getClassLoader();
        InputStream in = null;
        try {
            in = loader.getResourceAsStream("jdbcdslog.properties");
            props = new Properties(System.getProperties());
            if (in != null) {
                props.load(in);
            }
            ConfigurationParameters.initSlowQueryThreshold();
            ConfigurationParameters.initPrintStackTrace();
            ConfigurationParameters.initPrintFullStackTrace();
            ConfigurationParameters.initPrintStackTracePattern();
            ConfigurationParameters.initShowTime();
            ConfigurationParameters.initInlineQueryParams();
            ConfigurationParameters.initRdbmsSpecifics();
            ConfigurationParameters.initLogBeforeStatement();
            ConfigurationParameters.initLogDetailAfterStatement();
            ConfigurationParameters.initLogAddBatchDetail();
            ConfigurationParameters.initLogExecuteBatchDetail();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

