/*
 * Decompiled with CFR 0.152.
 */
package org.jdbcdslog;

import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jdbcdslog.LogUtils;
import org.jdbcdslog.Loggers;
import org.jdbcdslog.PreparedStatementLoggingHandler;
import org.jdbcdslog.ProxyUtils;

public class CallableStatementLoggingHandler
extends PreparedStatementLoggingHandler {
    protected TreeMap<String, Object> namedParameters = new TreeMap();
    protected List<Map<String, Object>> batchNamedParameters = null;

    public CallableStatementLoggingHandler(CallableStatement ps, String sql) {
        super(ps, sql);
    }

    protected boolean needsLogging(Object proxy, Method method, Object[] args) {
        return (Loggers.statementLogger.isInfoEnabled() || Loggers.slowQueryLogger.isInfoEnabled()) && EXECUTE_METHODS.contains(method.getName());
    }

    protected void appendStatement(StringBuilder sb, Object proxy, Method method, Object[] args) {
        LogUtils.appendSql(sb, this.sql, this.parameters, this.namedParameters);
    }

    protected void doAddBatch(Object proxy, Method method, Object[] args) {
        if (this.namedParameters.isEmpty()) {
            super.doAddBatch(proxy, method, args);
        } else {
            if (this.batchNamedParameters == null) {
                this.batchNamedParameters = new ArrayList<Map<String, Object>>();
            }
            this.batchNamedParameters.add(new TreeMap<String, Object>((SortedMap<String, Object>)this.namedParameters));
        }
    }

    protected void appendBatchStatements(StringBuilder sb) {
        LogUtils.appendBatchSqls(sb, this.sql, this.batchParameters, this.batchNamedParameters);
    }

    protected Object doAfterInvoke(Object proxy, Method method, Object[] args, Object result) {
        Object r = result;
        if ("unwrap".equals(method.getName())) {
            Class unwrapClass = (Class)args[0];
            if (r == this.target && unwrapClass.isInstance(proxy)) {
                r = proxy;
            } else if (unwrapClass.isInterface() && CallableStatement.class.isAssignableFrom(unwrapClass)) {
                r = ProxyUtils.wrapByCallableStatementProxy(r, this.sql);
            }
        }
        if (r instanceof ResultSet) {
            r = ProxyUtils.wrapByResultSetProxy((ResultSet)r);
        }
        if (SET_METHODS.contains(method.getName())) {
            if (args[0] instanceof Integer) {
                this.parameters.put((Integer)args[0], args[1]);
            } else if (args[0] instanceof String) {
                this.namedParameters.put((String)args[0], args[1]);
            }
        }
        if ("clearParameters".equals(method.getName())) {
            this.parameters.clear();
            this.namedParameters.clear();
        }
        return r;
    }

    protected void handleException(Throwable t, Object proxy, Method method, Object[] args) throws Throwable {
        LogUtils.handleException(t, Loggers.statementLogger, LogUtils.createLogEntry(method, this.sql, this.parameters, this.namedParameters));
    }
}

