/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jsf.core.action;

import java.util.Set;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.jsf.JbpmActionListener;
import org.jbpm.jsf.JbpmJsfContext;
import org.jbpm.jsf.core.impl.UpdatesHashMap;
import org.jbpm.taskmgmt.exe.TaskInstance;

public final class ApplyVariableMapActionListener
implements JbpmActionListener {
    private final ValueExpression variableMapExpression;
    private final ValueExpression targetExpression;

    public ApplyVariableMapActionListener(ValueExpression variableMapExpression, ValueExpression targetExpression) {
        this.variableMapExpression = variableMapExpression;
        this.targetExpression = targetExpression;
    }

    public String getName() {
        return "applyVariableMap";
    }

    public void handleAction(JbpmJsfContext context, ActionEvent event) {
        try {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ELContext elContext = facesContext.getELContext();
            UpdatesHashMap updatesHashMap = (UpdatesHashMap)this.variableMapExpression.getValue(elContext);
            Set<String> deletes = updatesHashMap.deletesSet();
            Set<String> updates = updatesHashMap.updatesSet();
            boolean updated = false;
            Object targetValue = this.targetExpression.getValue(elContext);
            if (targetValue instanceof ProcessInstance) {
                ProcessInstance processInstance = (ProcessInstance)targetValue;
                ContextInstance contextInstance = processInstance.getContextInstance();
                for (String name : deletes) {
                    contextInstance.deleteVariable(name);
                    updated = true;
                }
                for (String name : updates) {
                    contextInstance.setVariable(name, updatesHashMap.get(name));
                    updated = true;
                }
            } else if (targetValue instanceof Token) {
                Token token = (Token)targetValue;
                ProcessInstance processInstance = token.getProcessInstance();
                ContextInstance contextInstance = processInstance.getContextInstance();
                for (String name : deletes) {
                    contextInstance.deleteVariable(name, token);
                    updated = true;
                }
                for (String name : updates) {
                    contextInstance.setVariable(name, updatesHashMap.get(name), token);
                    updated = true;
                }
            } else if (targetValue instanceof TaskInstance) {
                TaskInstance task = (TaskInstance)targetValue;
                for (String name : deletes) {
                    task.deleteVariable(name);
                    updated = true;
                }
                for (String name : updates) {
                    task.setVariable(name, updatesHashMap.get(name));
                    updated = true;
                }
            } else {
                if (targetValue == null) {
                    context.setError("Error updating variable map", "The target value was given as null");
                    return;
                }
                context.setError("Error updating variable map", "The target value is not a recognized type");
                return;
            }
            if (updated) {
                context.addSuccessMessage("Variables updated");
            }
        }
        catch (Exception ex) {
            context.setError("Error updating variable map", ex);
        }
    }
}

