/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.server.integration.jbpm3;

import org.jboss.bpm.console.client.model.ProcessDefinitionRef;
import org.jboss.bpm.console.client.model.ProcessInstanceRef;
import org.jboss.bpm.console.client.model.ProcessInstanceRef.STATE;
import org.jboss.bpm.console.server.integration.ProcessManagement;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class JBPM3ProcessManagement implements ProcessManagement
{
   private JBPM3CommandDelegate delegate;

   public JBPM3ProcessManagement()
   {
      this.delegate = new JBPM3CommandDelegate();
   }

   public List<ProcessDefinitionRef> getProcessDefinitions()
   {
      List<ProcessDefinition> defs = delegate.getActualDefinitions();

      List<ProcessDefinitionRef> results = new ArrayList<ProcessDefinitionRef>(defs.size());
      for(ProcessDefinition p0 : defs)
      {
         results.add( Transform.processDefinition(p0) );
      }
      return results;
   }

   public ProcessDefinitionRef getProcessDefinition(long processId)
   {
      ProcessDefinition p0 = delegate.getActualDefinition(processId);
      return Transform.processDefinition(p0);
   }

   public List<ProcessDefinitionRef> removeProcessDefinition(long processId)
   {
      delegate.removeActualDefinition(processId);
      return getProcessDefinitions();
   }


   public ProcessInstanceRef newInstance(long processId)
   {
      ProcessInstance instance = delegate.startNewInstance(processId);
      return Transform.processInstance(instance);  
   }

   public List<ProcessInstanceRef> getProcessInstances(long processId)
   {
      List<ProcessInstance> instances = delegate.getActualInstances(processId);
      List<ProcessInstanceRef> results = new ArrayList<ProcessInstanceRef>(instances.size());
      for(org.jbpm.graph.exe.ProcessInstance i0 : instances)
      {
         results.add( Transform.processInstance(i0) );
      }
      return results;
   }

   public ProcessInstanceRef getProcessInstance(long instanceId)
   {
      ProcessInstance instance = delegate.getActualInstance(instanceId);
      return Transform.processInstance(instance);
   }

   public void setProcessState(long instanceId, STATE nextState)
   {
      ProcessInstance p0 = delegate.getActualInstance(instanceId);
      Transform.doTransition(p0, nextState);
   }

   public void signalToken(long tokenId, String signal)
   {
      delegate.signalToken(tokenId, signal);
   }

}
