/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.server;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.bpm.console.client.model.ProcessDefinitionRef;
import org.jboss.bpm.console.server.integration.ExtensionManagement;
import org.jboss.bpm.console.server.integration.ManagementFactory;
import org.jboss.bpm.console.server.integration.ProcessManagement;
import org.jboss.bpm.console.server.gson.GsonFactory;

import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

import com.google.gson.Gson;

/**
 * Test utility to simplify GWT tests.
 * 
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
@Path("test")
public class TestFacade
{
   private static final Log log = LogFactory.getLog(TaskMgmtFacade.class);
   
   private ExtensionManagement JBPM3Extension;
   private ProcessManagement processManagement;      

   private ExtensionManagement getManagementExtension()
   {
      if(null==this.JBPM3Extension)
      {
         ManagementFactory factory = ManagementFactory.newInstance();
         this.JBPM3Extension = factory.createExtensionManagement();
      }

      return this.JBPM3Extension;

   }

   private ProcessManagement getProcessManagement()
   {
      if(null==this.processManagement)
      {
         ManagementFactory factory = ManagementFactory.newInstance();
         this.processManagement = factory.createProcessManagement();
         log.debug("Using ManagementFactory impl:" + factory.getClass().getName());
      }

      return this.processManagement;
   }

   @POST
   @Path("deploy/harness")   
   public Response deployTestHarness()
   {
      try
      {
         InputStream in = getClass().getResourceAsStream("/WEB-INF/classes/SampleProcess.par");

         ByteArrayOutputStream out = new ByteArrayOutputStream();
         final int BUF_SIZE = 1 << 8;
         byte[] buffer = new byte[BUF_SIZE];
         int bytesRead = -1;
         while((bytesRead = in.read(buffer)) > -1) {
               out.write(buffer, 0, bytesRead);
         }
         in.close();
         byte[] data = out.toByteArray();

         ProcessDefinitionRef def = getManagementExtension().deployNewDefinition(data);
         log.info("Deployed test process definition " + def);
         
         return createJsonResponse(def);
      }
      catch (IOException e)
      {
         throw new WebApplicationException(e, 500);
      }     

   }

   @POST
   @Path("undeploy/harness")
   public Response undeployTestHarness()
   {
      List<ProcessDefinitionRef> defs = getProcessManagement().getProcessDefinitions();
      
      for(ProcessDefinitionRef pd : defs)
      {
         if(pd.getName().equals("GWT_Test_Harness"))
         {
            log.info("Remove test harness " +pd);
            getProcessManagement().removeProcessDefinition(pd.getProcessId());
         }
      }
      return Response.ok().build();
   }

   private Response createJsonResponse(Object wrapper)
   {
      Gson gson = GsonFactory.createInstance();
      String json = gson.toJson(wrapper);
      return Response.ok(json).type("application/json").build();
   }
}
