/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import org.jbpm.runtime.manager.impl.AbstractRuntimeManager;
import org.jbpm.runtime.manager.impl.PerCaseRuntimeManager;
import org.jbpm.runtime.manager.impl.PerProcessInstanceRuntimeManager;
import org.jbpm.runtime.manager.impl.PerRequestRuntimeManager;
import org.jbpm.runtime.manager.impl.SimpleRuntimeEnvironment;
import org.jbpm.runtime.manager.impl.SingletonRuntimeManager;
import org.jbpm.runtime.manager.impl.factory.InMemorySessionFactory;
import org.jbpm.runtime.manager.impl.factory.JPASessionFactory;
import org.jbpm.runtime.manager.impl.factory.LocalTaskServiceFactory;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.internal.runtime.manager.SessionFactory;
import org.kie.internal.runtime.manager.TaskServiceFactory;

public class RuntimeManagerFactoryImpl
implements RuntimeManagerFactory {
    public RuntimeManager newSingletonRuntimeManager(RuntimeEnvironment environment) {
        return this.newSingletonRuntimeManager(environment, "default-singleton");
    }

    public RuntimeManager newSingletonRuntimeManager(RuntimeEnvironment environment, String identifier) {
        SessionFactory factory = this.getSessionFactory(environment, identifier);
        TaskServiceFactory taskServiceFactory = this.getTaskServiceFactory(environment);
        SingletonRuntimeManager manager = new SingletonRuntimeManager(environment, factory, taskServiceFactory, identifier);
        ((AbstractRuntimeManager)manager).init();
        return manager;
    }

    public RuntimeManager newPerRequestRuntimeManager(RuntimeEnvironment environment) {
        return this.newPerRequestRuntimeManager(environment, "default-per-request");
    }

    public RuntimeManager newPerRequestRuntimeManager(RuntimeEnvironment environment, String identifier) {
        SessionFactory factory = this.getSessionFactory(environment, identifier);
        TaskServiceFactory taskServiceFactory = this.getTaskServiceFactory(environment);
        PerRequestRuntimeManager manager = new PerRequestRuntimeManager(environment, factory, taskServiceFactory, identifier);
        ((AbstractRuntimeManager)manager).init();
        return manager;
    }

    public RuntimeManager newPerProcessInstanceRuntimeManager(RuntimeEnvironment environment) {
        return this.newPerProcessInstanceRuntimeManager(environment, "default-per-pinstance");
    }

    public RuntimeManager newPerProcessInstanceRuntimeManager(RuntimeEnvironment environment, String identifier) {
        SessionFactory factory = this.getSessionFactory(environment, identifier);
        TaskServiceFactory taskServiceFactory = this.getTaskServiceFactory(environment);
        PerProcessInstanceRuntimeManager manager = new PerProcessInstanceRuntimeManager(environment, factory, taskServiceFactory, identifier);
        ((AbstractRuntimeManager)manager).init();
        return manager;
    }

    public RuntimeManager newPerCaseRuntimeManager(RuntimeEnvironment environment) {
        return this.newPerCaseRuntimeManager(environment, "default-per-case");
    }

    public RuntimeManager newPerCaseRuntimeManager(RuntimeEnvironment environment, String identifier) {
        SessionFactory factory = this.getSessionFactory(environment, identifier);
        TaskServiceFactory taskServiceFactory = this.getTaskServiceFactory(environment);
        PerCaseRuntimeManager manager = new PerCaseRuntimeManager(environment, factory, taskServiceFactory, identifier);
        ((AbstractRuntimeManager)manager).init();
        return manager;
    }

    protected SessionFactory getSessionFactory(RuntimeEnvironment environment, String owner) {
        Object factory = null;
        factory = environment.usePersistence() ? new JPASessionFactory(environment, owner) : new InMemorySessionFactory(environment, owner);
        return factory;
    }

    protected TaskServiceFactory getTaskServiceFactory(RuntimeEnvironment environment) {
        TaskServiceFactory taskServiceFactory = (TaskServiceFactory)((SimpleRuntimeEnvironment)environment).getEnvironmentTemplate().get("org.kie.internal.runtime.manager.TaskServiceFactory");
        if (taskServiceFactory != null) {
            return taskServiceFactory;
        }
        taskServiceFactory = new LocalTaskServiceFactory(environment);
        return taskServiceFactory;
    }
}

