/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.command;

import org.drools.core.command.impl.RegistryContext;
import org.jbpm.casemgmt.api.StageNotFoundException;
import org.jbpm.casemgmt.impl.command.CaseCommand;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.DynamicNodeInstance;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.identity.IdentityProvider;

public class TriggerAdHocNodeInStageCommand
extends CaseCommand<Void> {
    private static final long serialVersionUID = 6345222909719335954L;
    private String fragmentName;
    private String stageId;
    private long processInstanceId;
    private Object data;

    public TriggerAdHocNodeInStageCommand(IdentityProvider identityProvider, Long processInstanceId, String stageId, String fragmentName, Object data) {
        super(identityProvider);
        this.fragmentName = fragmentName;
        this.processInstanceId = processInstanceId;
        this.stageId = stageId;
        this.data = data;
        if (processInstanceId == null || stageId == null) {
            throw new IllegalArgumentException("Process instance id and stage id are mandatory");
        }
    }

    public Void execute(Context context) {
        KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        ProcessInstance processInstance = ksession.getProcessInstance(this.processInstanceId);
        DynamicNodeInstance dynamicContext = (DynamicNodeInstance)((WorkflowProcessInstanceImpl)processInstance).getNodeInstances(true).stream().filter(ni -> ni instanceof DynamicNodeInstance && this.stageId.equals(ni.getNode().getMetaData().get("UniqueId"))).findFirst().orElseThrow(() -> new StageNotFoundException("No stage found with id " + this.stageId));
        dynamicContext.signalEvent(this.fragmentName, this.data);
        return null;
    }
}

