/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.Iterator;
import java.util.List;
import org.drools.core.xml.ExtensibleXmlParser;
import org.jbpm.bpmn2.core.Interface;
import org.jbpm.bpmn2.xml.TaskHandler;
import org.jbpm.compiler.xml.ProcessBuildData;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ServiceTaskHandler
extends TaskHandler {
    @Override
    protected Node createNode(Attributes attrs) {
        return new WorkItemNode();
    }

    public Class generateNodeFor() {
        return Node.class;
    }

    @Override
    protected void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        WorkItemNode workItemNode = (WorkItemNode)node;
        String operationRef = element.getAttribute("operationRef");
        String implementation = element.getAttribute("implementation");
        List interfaces = (List)((ProcessBuildData)parser.getData()).getMetaData("Interfaces");
        workItemNode.setMetaData("OperationRef", (Object)operationRef);
        workItemNode.setMetaData("Implementation", (Object)implementation);
        workItemNode.setMetaData("Type", (Object)"Service Task");
        if (interfaces != null) {
            Interface i;
            Interface.Operation operation = null;
            Iterator i$ = interfaces.iterator();
            while (i$.hasNext() && (operation = (i = (Interface)i$.next()).getOperation(operationRef)) == null) {
            }
            if (operation == null) {
                throw new IllegalArgumentException("Could not find operation " + operationRef);
            }
            if (workItemNode.getWork().getParameter("Interface") == null) {
                workItemNode.getWork().setParameter("Interface", (Object)operation.getInterface().getName());
            }
            if (workItemNode.getWork().getParameter("Operation") == null) {
                workItemNode.getWork().setParameter("Operation", (Object)operation.getName());
            }
            if (workItemNode.getWork().getParameter("ParameterType") == null) {
                workItemNode.getWork().setParameter("ParameterType", (Object)operation.getMessage().getType());
            }
            if (implementation != null) {
                workItemNode.getWork().setParameter("interfaceImplementationRef", (Object)operation.getInterface().getImplementationRef());
                workItemNode.getWork().setParameter("operationImplementationRef", (Object)operation.getImplementationRef());
                workItemNode.getWork().setParameter("implementation", (Object)implementation);
            }
        }
    }

    @Override
    protected String getTaskName(Element element) {
        return "Service Task";
    }

    public void writeNode(Node node, StringBuilder xmlDump, boolean includeMeta) {
        throw new IllegalArgumentException("Writing out should be handled by TaskHandler");
    }
}

