/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

public final class Sequence<T>
extends AbstractList<T>
implements List<T>,
RandomAccess,
Serializable {
    private static final long serialVersionUID = 3042164316147742903L;
    private final Object[] values;
    private static final Object[] empty = new Object[0];
    private static final Sequence<?> EMPTY = new Sequence(empty);

    private Sequence(Object[] values) {
        Object[] realValues = (Object[])values.clone();
        this.values = realValues;
        for (Object realValue : realValues) {
            if (realValue != null) continue;
            throw new NullPointerException("value member is null");
        }
    }

    public static <T> Sequence<T> of(T ... members) {
        if (members.length == 0) {
            return Sequence.empty();
        }
        return new Sequence<T>(members);
    }

    public static <T> Sequence<T> of(Collection<T> members) {
        if (members instanceof Sequence) {
            return (Sequence)members;
        }
        Object[] objects = members.toArray();
        if (objects.length == 0) {
            return Sequence.empty();
        }
        return new Sequence<T>(objects);
    }

    public <N> Sequence<N> cast(Class<N> newType) throws ClassCastException {
        for (Object value : this.values) {
            newType.cast(value);
        }
        return this;
    }

    public static <T> Sequence<T> empty() {
        return EMPTY;
    }

    @Override
    public Iterator<T> iterator() {
        return Arrays.asList(this.values).iterator();
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public boolean isEmpty() {
        return this.values.length == 0;
    }

    @Override
    public Object[] toArray() {
        return (Object[])this.values.clone();
    }

    @Override
    public T get(int index) {
        return (T)this.values[index];
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof Sequence && this.equals((Sequence)other);
    }

    public boolean equals(Sequence<?> other) {
        return this == other || other != null && Arrays.equals(this.values, other.values);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.values);
    }
}

